% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-MChromatograms.R,
%   R/methods-XChromatograms.R
\name{filterColumnsIntensityAbove,MChromatograms-method}
\alias{filterColumnsIntensityAbove,MChromatograms-method}
\alias{filterColumnsIntensityAbove}
\alias{filterColumnsKeepTop}
\alias{filterColumnsKeepTop,MChromatograms-method}
\alias{filterColumnsIntensityAbove,XChromatograms-method}
\alias{filterColumnsKeepTop,XChromatograms-method}
\title{Filtering sets of chromatographic data}
\usage{
\S4method{filterColumnsIntensityAbove}{MChromatograms}(
  object,
  threshold = 0,
  value = c("bpi", "tic"),
  which = c("any", "all")
)

\S4method{filterColumnsKeepTop}{MChromatograms}(
  object,
  n = 1L,
  sortBy = c("bpi", "tic"),
  aggregationFun = sum
)

\S4method{filterColumnsIntensityAbove}{XChromatograms}(
  object,
  threshold = 0,
  value = c("bpi", "tic", "maxo", "into"),
  which = c("any", "all")
)

\S4method{filterColumnsKeepTop}{XChromatograms}(
  object,
  n = 1L,
  sortBy = c("bpi", "tic", "maxo", "into"),
  aggregationFun = sum
)
}
\arguments{
\item{object}{\code{\link[MSnbase:MChromatograms-class]{MSnbase::MChromatograms()}} or \code{\link[=XChromatograms]{XChromatograms()}} object.}

\item{threshold}{for \code{filterColumnsIntensityAbove}: \code{numeric(1)} with the
threshold value to compare against.}

\item{value}{\code{character(1)} defining which value should be used in the
comparison or sorting. Can be \code{value = "bpi"} (default) to use the
maximum intensity per chromatogram or \code{value = "tic"} to use the sum
of intensities per chromatogram. For \code{\link[=XChromatograms]{XChromatograms()}} objects also
\code{value = "maxo"} and \code{value = "into"} is supported to use the maximum
intensity or the integrated area of identified chromatographic peaks
in each chromatogram.}

\item{which}{for \code{filterColumnsIntensityAbove}: \code{character(1)} defining
whether \strong{any} (\code{which = "any"}, default) or \strong{all} (\code{which = "all"})
chromatograms in a column have to fulfill the criteria for the column
to be kept.}

\item{n}{for \code{filterColumnsKeepTop}: \code{integer(1)} specifying the number of
columns that should be returned. \code{n} will be rounded to the closest
(larger) integer value.}

\item{sortBy}{for \code{filterColumnsKeepTop}: the value by which columns should
be ordered to determine the top n columns. Can be either \code{sortBy = "bpi"}
(the default), in which case the maximum intensity of each column's
chromatograms is used, or \code{sortBy = "tic"} to use the total intensity
sum of all chromatograms. For \code{\link[=XChromatograms]{XChromatograms()}} objects also
\code{value = "maxo"} and \code{value = "into"} is supported to use the maximum
intensity or the integrated area of identified chromatographic peaks
in each chromatogram.}

\item{aggregationFun}{for \code{filterColumnsKeepTop}: function to be used to
aggregate (combine) the values from all chromatograms in each column.
Defaults to \code{aggregationFun = sum} in which case the sum of the values
is used to rank the columns. Alternatively the \code{mean}, \code{median} or
similar function can be used.}
}
\value{
a filtered \code{MChromatograms} (or \code{XChromatograms}) object with the
same number of rows (EICs) but eventually a lower number of columns
(samples).
}
\description{
These functions allow to filter (subset) \code{\link[MSnbase:MChromatograms-class]{MSnbase::MChromatograms()}} or
\code{\link[=XChromatograms]{XChromatograms()}} objects, i.e. sets of chromatographic data, without
changing the data (intensity and retention times) within the individual
chromatograms (\code{\link[MSnbase:Chromatogram-class]{MSnbase::Chromatogram()}} objects).
\itemize{
\item \code{filterColumnsIntensityAbove}: subsets a \code{MChromatograms} objects keeping
only columns (samples) for which \code{value} is larger than the provided
\code{threshold} in \code{which} rows (i.e. if \code{which = "any"} a
column is kept if \strong{any} of the chromatograms in that column have a
\code{value} larger than \code{threshold} or with \code{which = "all"} \strong{all}
chromatograms in that column fulfill this criteria). Parameter \code{value}
allows to define on which value the comparison should be performed, with
\code{value = "bpi"} the maximum intensity of each chromatogram is compared to
\code{threshold}, with \verb{value = "tic" the total sum of intensities of each chromatogram is compared to }threshold\verb{. For }XChromatograms\verb{object,}value = "maxo"\code{and}value = "into"\verb{are supported which compares the largest intensity of all identified chromatographic peaks in the chromatogram with}threshold`, or the integrated peak area, respectively.
\item \code{filterColumnsKeepTop}: subsets a \code{MChromatograms} object keeping the top
\code{n} columns sorted by the value specified with \code{sortBy}. In detail, for
each column the value defined by \code{sortBy} is extracted from each
chromatogram and aggregated using the \code{aggregationFun}. Thus, by default,
for each chromatogram the maximum intensity is determined
(\code{sortBy = "bpi"}) and these values are summed up for chromatograms in the
same column (\code{aggregationFun = sum}). The columns are then sorted by these
values and the top \code{n} columns are retained in the returned
\code{MChromatograms}. Similar to the \code{filterColumnsIntensityAbove} function,
this function allows to use for \code{XChromatograms} objects to sort the
columns by column \code{sortBy = "maxo"} or \code{sortBy = "into"} of the
\code{chromPeaks} matrix.
}
}
\examples{

library(MSnbase)
chr1 <- Chromatogram(rtime = 1:10 + rnorm(n = 10, sd = 0.3),
    intensity = c(5, 29, 50, NA, 100, 12, 3, 4, 1, 3))
chr2 <- Chromatogram(rtime = 1:10 + rnorm(n = 10, sd = 0.3),
    intensity = c(80, 50, 20, 10, 9, 4, 3, 4, 1, 3))
chr3 <- Chromatogram(rtime = 3:9 + rnorm(7, sd = 0.3),
    intensity = c(53, 80, 130, 15, 5, 3, 2))

chrs <- MChromatograms(list(chr1, chr2, chr1, chr3, chr2, chr3),
    ncol = 3, byrow = FALSE)
chrs

#### filterColumnsIntensityAbove
##
## Keep all columns with for which the maximum intensity of any of its
## chromatograms is larger 90
filterColumnsIntensityAbove(chrs, threshold = 90)

## Require that ALL chromatograms in a column have a value larger 90
filterColumnsIntensityAbove(chrs, threshold = 90, which = "all")

## If none of the columns fulfills the criteria no columns are returned
filterColumnsIntensityAbove(chrs, threshold = 900)

## Filtering XChromatograms allow in addition to filter on the columns
## "maxo" or "into" of the identified chromatographic peaks within each
## chromatogram.

#### filterColumnsKeepTop
##
## Keep the 2 columns with the highest sum of maximal intensities in their
## chromatograms
filterColumnsKeepTop(chrs, n = 1)

## Keep the 50 percent of columns with the highest total sum of signal. Note
## that n will be rounded to the next larger integer value
filterColumnsKeepTop(chrs, n = 0.5 * ncol(chrs), sortBy = "tic")
}
\author{
Johannes Rainer
}
