% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-XCMSnExp.R
\name{applyAdjustedRtime}
\alias{applyAdjustedRtime}
\title{Replace raw with adjusted retention times}
\usage{
applyAdjustedRtime(object)
}
\arguments{
\item{object}{An \link{XCMSnExp} or \link{XcmsExperiment} object.}
}
\value{
An \code{XCMSnExp} or \code{XcmsExperiment} object with the raw (original) retention
times being replaced with the adjusted retention time.
}
\description{
Replaces the raw retention times with the adjusted retention
time or returns the object unchanged if none are present.
}
\details{
Adjusted retention times are stored \emph{in parallel} to the adjusted
retention times in \code{XCMSnExp} or \code{XcmsExperiment} objects. The
\code{applyAdjustedRtime} replaces the raw (original) retention times with the
adjusted retention times.
}
\note{
Replacing the raw retention times with adjusted retention times
disables the possibility to restore raw retention times using the
\code{\link[=dropAdjustedRtime]{dropAdjustedRtime()}} method. This function does \strong{not} remove the
retention time processing step with the settings of the alignment from
the \code{\link[=processHistory]{processHistory()}} of the \code{object} to ensure that the processing
history is preserved.
}
\examples{

## Load a test data set with detected peaks
library(MSnbase)
data(faahko_sub)
## Update the path to the files for the local system
dirname(faahko_sub) <- system.file("cdf/KO", package = "faahKO")

## Disable parallel processing for this example
register(SerialParam())

xod <- adjustRtime(faahko_sub, param = ObiwarpParam())

hasAdjustedRtime(xod)

## Replace raw retention times with adjusted retention times.
xod <- applyAdjustedRtime(xod)

## No adjusted retention times present
hasAdjustedRtime(xod)

## Raw retention times have been replaced with adjusted retention times
plot(split(rtime(faahko_sub), fromFile(faahko_sub))[[1]] -
    split(rtime(xod), fromFile(xod))[[1]], type = "l")

## And the process history still contains the settings for the alignment
processHistory(xod)
}
\seealso{
\code{\link[=adjustRtime]{adjustRtime()}} for the function to perform the alignment (retention
time correction).

\if{html}{\out{<div class="sourceCode">}}\preformatted{[adjustedRtime()] for the method to extract adjusted retention times from
an [XCMSnExp] object.

[dropAdjustedRtime] for the method to delete alignment results and to
restore the raw retention times.
}\if{html}{\out{</div>}}
}
\author{
Johannes Rainer
}
