% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XcmsExperiment.R, R/do_adjustRtime-functions.R,
%   R/functions-Params.R, R/methods-Params.R
\name{adjustRtime,XcmsExperiment,LamaParama-method}
\alias{adjustRtime,XcmsExperiment,LamaParama-method}
\alias{LamaParama}
\alias{LamaParama-class}
\alias{matchLamasChromPeaks}
\alias{summarizeLamaMatch}
\alias{matchedRtimes}
\alias{plot,LamaParama,ANY-method}
\title{Landmark-based alignment: aligning a dataset against an external
reference}
\usage{
\S4method{adjustRtime}{XcmsExperiment,LamaParama}(object, param, BPPARAM = bpparam(), ...)

matchLamasChromPeaks(object, param, BPPARAM = bpparam())

summarizeLamaMatch(param)

matchedRtimes(param)

LamaParama(
  lamas = matrix(ncol = 2, nrow = 0, dimnames = list(NULL, c("mz", "rt"))),
  method = c("loess", "gam"),
  span = 0.5,
  outlierTolerance = 3,
  zeroWeight = 10,
  ppm = 20,
  tolerance = 0,
  toleranceRt = 5,
  bs = "tp"
)

\S4method{plot}{LamaParama,ANY}(
  x,
  index = 1L,
  colPoints = "#00000060",
  colFit = "#00000080",
  xlab = "Matched Chromatographic peaks",
  ylab = "Lamas",
  ...
)
}
\arguments{
\item{object}{An object of class \code{XcmsExperiment} with defined ChromPeaks.}

\item{param}{An object of class \code{LamaParama} that will later be used for
adjustment using the \code{\link[=adjustRtime]{adjustRtime()}} function.}

\item{BPPARAM}{For \code{matchLamasChromPeaks()}: parallel processing setup.
Defaults to \code{BPPARAM = bpparam()}. See \code{\link[BiocParallel:register]{BiocParallel::bpparam()}} for
more information.}

\item{...}{For \code{plot()}: extra parameters to be passed to the function.}

\item{lamas}{For \code{LamaParama}: \code{matrix} or \code{data.frame} with the m/z and
retention times values of features (as first and second column) from the
external dataset on which the alignment will be based on.}

\item{method}{For \code{LamaParama}:\code{character(1)} with the type of warping.
Either \code{method = "gam"} or \code{method = "loess"} (default).}

\item{span}{For \code{LamaParama}: \code{numeric(1)} defining
the degree of smoothing (\code{method = "loess"}). This parameter is passed
to the internal call to \code{\link[=loess]{loess()}}.}

\item{outlierTolerance}{For \code{LamaParama}: \code{numeric(1)} defining the settings
for outlier removal during the fitting. By default
(with \code{outlierTolerance = 3}), all data points with absolute residuals
larger than 3 times the mean absolute residual of all data points from
the first, initial fit, are removed from the final model fit.}

\item{zeroWeight}{For \code{LamaParama}: \code{numeric(1)}: defines the weight of the
first data point (i.e. retention times of the first lama-chromatographic
peak pair). Values larger than 1 reduce warping problems in the early RT
range.}

\item{ppm}{For \code{LamaParama}: \code{numeric(1)} defining the m/z-relative maximal
allowed difference in m/z between \code{lamas} and chromatographic peaks. Used
for the mapping of identified chromatographic peaks and lamas.}

\item{tolerance}{For \code{LamaParama}: \code{numeric(1)} defining the absolute
acceptable difference in m/z between lamas and chromatographic peaks.
Used for the mapping of identified chromatographic peaks and \code{lamas}.}

\item{toleranceRt}{For \code{LamaParama}: \code{numeric(1)} defining the absolute
acceptable difference in retention time between lamas and
chromatographic peaks. Used for the mapping of identified chromatographic
peaks and \code{lamas}.}

\item{bs}{For \code{LamaParama()}: \code{character(1)} defining the GAM smoothing method.
(defaults to thin plate, \code{bs = "tp"})}

\item{x}{For \code{plot()}: object of class \code{LamaParama} to be plotted.}

\item{index}{For \code{plot()}: \code{numeric(1)} index of the file that should be
plotted.}

\item{colPoints}{For \code{plot()}: color for the plotting of the datapoint.}

\item{colFit}{For \code{plot()}: color of the fitting line.}

\item{xlab, ylab}{For \code{plot()}: x- and y-axis labels.}
}
\value{
For \code{matchLamasChromPeaks()}: A \code{LamaParama} object with new slot \code{rtMap}
composed of a list of matrices representing the 1:1 matches between Lamas
(ref) and ChromPeaks (obs). To access this, \code{matchedRtimes()} can be used.

For \code{matchedRtimes()}: A list of \code{data.frame} representing matches
between chromPeaks and \code{lamas} for each files.

For \code{summarizeLamaMatch()}:A \code{data.frame} with:
\itemize{
\item "Total_peaks": total number of chromatographic peaks in the file.
\item "Matched_peak": The number of matched peaks to Lamas.
\item "Total_Lamas": Total number of Lamas.
\item "Model_summary": \code{summary.loess} or \code{summary.gam} object for each file.
}
}
\description{
Alignment is achieved using the \code{\link[=adjustRtime]{adjustRtime()}} method with a \code{param} of
class \code{LamaParama}. This method corrects retention time by aligning
chromatographic data with an external reference dataset.

Chromatographic peaks in the experimental data are first matched to
predefined (external) landmark features based on their mass-to-charge ratio
and retention time and subsequently the data is aligned by minimizing the
differences in retention times between the matched chromatographic peaks and
lamas. This adjustment is performed file by file.

Adjustable parameters such as \code{ppm}, \code{tolerance}, and \code{toleranceRt} define
acceptable deviations during the matching process. It's crucial to note that
only lamas and chromatographic peaks exhibiting a one-to-one mapping are
considered when estimating retention time shifts. If a file has no peaks
matching with lamas, no adjustment will be performed, and the the retention
times will be returned as-is. Users can evaluate this matching, for example,
by checking the number of matches and ranges of the matching peaks, by first
running \verb{[matchLamasChromPeaks()]}.

Different warping methods are available; users can choose to fit a \emph{loess}
(\code{method = "loess"}, the default) or a \emph{gam} (\code{method = "gam"}) between the
reference data points and observed matching ChromPeaks. Additional
parameters such as \code{span}, \code{weight}, \code{outlierTolerance}, \code{zeroWeight},
and \code{bs} are specific to these models. These parameters offer flexibility
in fine-tuning how the matching chromatographic peaks are fitted to the
lamas, thereby generating a model to align the overall retention time for
a single file.

Other functions related to this method:
\itemize{
\item \code{LamaParama()}: return the respective parameter object for alignment
using \code{adjustRtime()} function. It is also the input for the functions
listed below.
\item \code{matchLamasChromPeaks()}: quickly matches each file's ChromPeaks
to Lamas, allowing the user to evaluate the matches for each file.
\item \code{summarizeLamaMatch()}: generates a summary of the \code{LamaParama} method.
See below for the details of the return object.
\item \code{matchedRtimes()}: Access the list of \code{data.frame} saved in the
\code{LamaParama} object, generated by the \code{matchLamasChromPeaks()} function.
\item \code{plot()}:plot the chromatographic peaks versus the reference lamas as
well as the fitting line for the chosen model type. The user can decide
what file to inspect by specifying the assay number with the parameter
\code{assay}
}
}
\note{
If there are no matches when using \code{matchLamasChromPeaks()}, the file
retention will not be adjusted when calling \code{\link[=adjustRtime]{adjustRtime()}} with the same
\code{LamaParama} and \code{XcmsExperiment} object.

To see examples on how to utilize this methods and its functionality,
see the vignette.
}
\examples{
## load test and reference datasets
ref <- loadXcmsData("xmse")
tst <- loadXcmsData("faahko_sub2")

## create lamas input from the reference dataset
library(MsExperiment)
f <- sampleData(ref)$sample_type
f[f == "QC"] <- NA
ref <- filterFeatures(ref, PercentMissingFilter(threshold = 0, f = f))
ref_mz_rt <- featureDefinitions(ref)[, c("mzmed","rtmed")]

## Set up the LamaParama object
param <- LamaParama(lamas = ref_mz_rt, method = "loess", span = 0.5,
                     outlierTolerance = 3, zeroWeight = 10, ppm = 20,
                     tolerance = 0, toleranceRt = 20, bs = "tp")

## input into `adjustRtime()`
tst_adjusted <- adjustRtime(tst, param = param)

## run diagnostic functions to pre-evaluate alignment
param <- matchLamasChromPeaks(tst, param = param)
mtch <- matchedRtimes(param)

## Access summary of matches and model information
summary <- summarizeLamaMatch(param)

##coverage for each file
summary$Matched_peaks / summary$Total_peaks * 100

## Access the information on the model of for the first file
summary$model_summary[[1]]

}
\author{
Carl Brunius, Philippine Louail
}
