% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xcell2object-generics.R,
%   R/xcell2object-methods.R
\name{signatures}
\alias{signatures}
\alias{setSignatures<-}
\alias{getSignatures,xCell2Object-method}
\alias{getSignatures}
\alias{setSignatures<-,xCell2Object-method}
\title{Access Cell Type Signatures}
\usage{
getSignatures(object)

setSignatures(object) <- value

\S4method{getSignatures}{xCell2Object}(object)

\S4method{setSignatures}{xCell2Object}(object) <- value
}
\arguments{
\item{object}{An \linkS4class{xCell2Object}.}

\item{value}{A list of cell type-specific gene signatures (for the setter).}
}
\value{
For `getSignatures`, a list of cell type-specific gene signatures. 
        For `setSignatures<-`, the updated \linkS4class{xCell2Object}.

For `getSignatures`, a list of cell type-specific gene signatures. 
        For `setSignatures<-`, the updated \linkS4class{xCell2Object}.
}
\description{
Retrieve or assign the cell type-specific gene signatures for an \linkS4class{xCell2Object}.

Retrieve or assign the cell type-specific gene signatures for an \linkS4class{xCell2Object}.
}
\examples{
data(DICE_demo.xCell2Ref, package = "xCell2")
setSignatures(DICE_demo.xCell2Ref) <- list("T_cells" = c("GeneA", "GeneB"), "B_cells" = c("GeneC"))
getSignatures(DICE_demo.xCell2Ref)
data(DICE_demo.xCell2Ref, package = "xCell2")
setSignatures(DICE_demo.xCell2Ref) <- list("T_cells" = c("GeneA", "GeneB"))
}
\seealso{
\link{xCell2Object-class}

\link{xCell2Object-class}
}
