% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{TMECompendium.xCell2Ref}
\alias{TMECompendium.xCell2Ref}
\title{Tumor Microenvironment Compendium Reference}
\format{
An \code{xCell2Object} containing:
\describe{
  \item{\code{params}}{Linear transformation parameters.}
  \item{\code{signatures}}{Cell-type-specific gene signatures.}
  \item{\code{dependencies}}{Cell type lineage dependencies.}
  \item{\code{spill_mat}}{Spillover correction matrix.}
  \item{\code{genes_used}}{Genes included in the reference.}
}
}
\source{
Curated by Zaitsev A (2022) and trained by Angel A, et al. (2024).
}
\usage{
data(TMECompendium.xCell2Ref, package = "xCell2")
}
\description{
Pre-trained xCell2 reference object for analyzing tumor microenvironments.
}
\details{
Tumor Microenvironment Compendium Reference (human)

An xCell2 reference object created from the Tumor Microenvironment Compendium dataset.


Normalized data for training can be accessed at:  
\url{https://science.bostongene.com/kassandra/downloads}.
}
\references{
Zaitsev, A., et al. (2022). Cancer Cell, 40(8), 879-894.
}
\seealso{
\code{\link{xCell2Analysis}} and \code{\link{xCell2Train}}.
}
\keyword{datasets,}
\keyword{references}
