% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WPPI_functions.R
\name{prioritization_genes}
\alias{prioritization_genes}
\title{Candidate genes prioritization}
\usage{
prioritization_genes(
  graph_op,
  prob_matrix,
  genes_interest,
  percentage_genes_ranked = 100
)
}
\arguments{
\item{graph_op}{Igraph object based on OmniPath PPI interactions from
\code{\link{graph_from_op}}.}

\item{prob_matrix}{Matrix object with correlations/probabilities of the
all nodes in the network from \code{\link{random_walk}}.}

\item{genes_interest}{Character vector with known-disease specific genes.}

\item{percentage_genes_ranked}{Positive integer (range between 0 and 100)
specifying the percentage (%) of the total candidate genes in the
network returned in the output. If not specified, the score of all the
candidate genes is delivered.}
}
\value{
Data frame with the ranked candidate genes based on the functional
    score inferred from given ontology terms, PPI and Random Walk with
    Restart parameters.
}
\description{
Ranks candidate genes based on correlation with the given seed
genes of interest. For this, the source proteins/genes (i.e. starting
nodes) are reduced to the candidate genes and the target proteins/genes
(i.e. end nodes) to the given genes of interest. Each candidate gene
score is defined by the sum of its correlations towards the known
disease-related genes.
}
\examples{
db <- wppi_data()
GO_data <- db$go
HPO_data <- db$hpo
# Genes of interest
genes_interest <-
    c("ERCC8", "AKT3", "NOL3", "GFI1B", "CDC25A", "TPX2", "SHE")
# Graph object with PPI 
graph_op <- graph_from_op(db$omnipath)
graph_op_1 <- subgraph_op(graph_op, genes_interest, 1)
# Filter ontology data
GO_data_filtered <- filter_annot_with_network(GO_data, graph_op_1)
HPO_data_filtered <- filter_annot_with_network(HPO_data, graph_op_1)
# Weighted adjacency
w_adj <- weighted_adj(graph_op_1, GO_data_filtered, HPO_data_filtered)
# Random Walk with Restart
w_rw <- random_walk(w_adj)
# Ranked candidate genes
scores <- prioritization_genes(graph_op_1, w_rw, genes_interest)

}
\seealso{
\itemize{
    \item{\code{\link{graph_from_op}}}
    \item{\code{\link{weighted_adj}}}
    \item{\code{\link{random_walk}}}
    \item{\code{\link{score_candidate_genes_from_PPI}}}
}
}
