% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_generate_map.R
\name{generateMap}
\alias{generateMap}
\title{Generate a plate map according to the input parameters}
\usage{
generateMap(
  user_df,
  nb_rows,
  nb_cols,
  df_forbidden,
  mod,
  max_it,
  updateProgress = NULL
)
}
\arguments{
\item{user_df}{dataframe containing 9 features: Sample, ID, Group,
Sample.name, Well, Status, Row, Column, Plate. See details.}

\item{nb_rows}{numeric, number of lines on the plate}

\item{nb_cols}{numeric, number of columns on the plate}

\item{df_forbidden}{dataframe with the same structure than user_df, but for
the forbidden, buffer solutions and Not randomized wells.}

\item{mod}{character, neighborhood spatial constraint}

\item{max_it}{numeric, maximum number of attempts to generate a plate plan
before returning a failure.}

\item{updateProgress}{shiny object, reports progress to the user.}
}
\value{
Returns a dataframe containing all the data of the plate map(s)
}
\description{
This function generates a plate map using a backtracking
algorithm and returns a dataframe if success. If it fails to find a
solution, returns NULL. If there are not enough wells to place all the
samples, returns 0.
}
\details{
The dataframe is generated using dedicated functions of the {wpm}
package: `convertCSV()`, `convertESet()` or `convertSE()`. But the user can
also generate it by hand.

A number of attempts is allowed. Consequently, if the maximal
number if attempts is reeched and no solution was found with the
backtracking (i.e. the randomWalk does not return a dataframe), this
function prints a warning message and returns NULL. If a solution is
found, then it returns the dataframe.
}
