% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wavClusteR-package.R
\docType{package}
\name{wavClusteR-package}
\alias{wavClusteR-package}
\alias{wavClusteR}
\title{A comprehensive pipeline for the analysis of PAR-CLIP data. PAR-CLIP-induced 
transitions are first discriminated from sequencing errors, SNPs and additional non-
experimental sources by a non-parametric mixture model. The protein binding sites 
(clusters) are then resolved at high resolution and cluster statistics are estimated 
using a rigorous Bayesian framework. Post-processing of the results, data export for 
UCSC genome browser visualization and motif search analysis are provided. In addition, 
the package allows to integrate RNA-Seq data to estimate the False Discovery Rate of 
cluster detection.  Key functions support parallel multicore computing. Note: while 
wavClusteR was designed for PAR-CLIP data analysis, it can be applied to the analysis of 
other NGS data obtained from experimental procedures that induce nucleotide 
substitutions (e.g. BisSeq).}
\description{
\tabular{ll}{ Package: \tab wavClusteR\cr Type: \tab Package\cr Version:
\tab 2.5.0\cr Date: \tab 2016-01-09\cr License: \tab GPL-2\cr }
}
\references{
Comoglio F, Sievers C and Paro R (2015) Sensitive and highly resolved identification
of RNA-protein interaction sites in PAR-CLIP data, BMC Bioinformatics 16, 32.

Sievers C, Schlumpf T, Sawarkar R, Comoglio F and Paro R. (2012) Mixture
models and wavelet transforms reveal high confidence RNA-protein interaction
sites in MOV10 PAR-CLIP data, Nucleic Acids Res. 40(20):e160. doi:
10.1093/nar/gks697
}
\author{
Federico Comoglio and Cem Sievers

Epigenomics Group

Department of Biosystems Science and Engineering (D-BSSE)

ETH Zurich, Switzerland

Maintainer: Federico Comoglio

\email{federico.comoglio@gmail.com}
}
\keyword{package}
