% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSubstitutions.R
\name{plotSubstitutions}
\alias{plotSubstitutions}
\title{Barplot visualization of the number of genomic positions exhibiting a given
substitution and, if model provided, additional diagnostic plots.}
\usage{
plotSubstitutions(countTable, highlight = "TC", model)
}
\arguments{
\item{countTable}{A GRanges object, corresponding to a count table as
returned by the \link{getAllSub} function}

\item{highlight}{A character indicating which substitution should be
highlighted in the barplot. A standard PAR-CLIP experiment employing 4-SU
treatment induces T to C transitions, encoded as "TC". Default is "TC".}

\item{model}{A list containing the model as returned by the function
\code{fitMixtureModel}}
}
\value{
called for its effect
}
\description{
Graphical representation of the total number of genomic positions exhibiting
one or more substitutions of a given type. This information is used to
estimate the mixing coefficients of the non-parametric mixture model. If the
mixture model fit is provided, returns additional diagnostic plots such as
the total number of reads exhibiting a given substitution and relative
substitution frequency-dependent representations of the total number of
genomic positions with substitutions of a given type.
}
\examples{

filename <- system.file( "extdata", "example.bam", package = "wavClusteR" )
example <- readSortedBam( filename = filename )
countTable <- getAllSub( example, minCov = 10, cores = 1 )
plotSubstitutions(countTable = countTable, highlight = "TC")

}
\seealso{
\code{\link{getAllSub}}
}
\author{
Federico Comoglio and Cem Sievers
}
\keyword{graphics}
