% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustedDasen.R
\name{adjustedDasen}
\alias{adjustedDasen}
\title{adjustedDasen}
\usage{
adjustedDasen(
  mns,
  uns,
  onetwo,
  chr,
  offset_fit = TRUE,
  cores = 1,
  ret2 = FALSE,
  fudge = 100,
  ...
)
}
\arguments{
\item{mns}{matrix of methylated signal intensities, samples in column and 
probes in row.}

\item{uns}{matrix of unmethylated signal intensities, samples in column and 
probes in row.}

\item{onetwo}{character vector or factor of length nrow(mns) indicating assay
type 'I' or 'II'.}

\item{chr}{character vector stores the mapped chromosomes for all probes, e.g. 
chr <- c('1', 'X', '21', ..., 'Y').}

\item{offset_fit}{logical (default is TRUE). To use dasen, set it TRUE; to use
nasen, set it FALSE.}

\item{cores}{an integer(e.g. 8) defines the number of cores to parallel processing. 
Default value is 1, set to -1 to use all available cores.}

\item{ret2}{logical (default is FALSE), if TRUE, returns a list of intensities 
and betas instead of a naked matrix of betas.}

\item{fudge}{default 100, a value added to total intensity to prevent denominators 
close to zero when calculating betas, e.g. betas <- mns / (mns + uns + fudge).}

\item{...}{additional argument roco for dfsfit giving Sentrix rows and 
columns.  This allows a background gradient model to be fit. This is split 
from data column names by default.  roco=NULL disables model fitting (and 
speeds up processing), otherwise roco can be supplied as a character vector 
of strings like 'R01C01' (only 3rd and 6th characters used).}
}
\value{
a matrix of normalised beta values.
}
\description{
adjustedDasen utilizes dasen normliasation to normalise autosomal
CpGs, and infers the sex chromosome linked CpGs by linear interpolation on 
corrected autosomal CpGs.
}
\examples{
data(melon)
normalised_betas <- adjustedDasen(mns = methylated(melon), uns = unmethylated(melon), onetwo = fData(melon)[,fot(melon)], chr = fData(melon)$CHR, cores=1)
## if input is an object of methylumiset or methylset
normalised_betas <- adjustedDasen(melon)

}
\references{
A data-driven approach to preprocessing Illumina 450K methylation array data, 
Pidsley et al, BMC Genomics. \cr
interpolatedXY: a two-step strategy to normalise DNA methylation 
microarray data avoiding sex bias, Wang et al., 2021.
}
