% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{corr2p}
\alias{corr2p}
\title{Convert correlation coefficient to p-value}
\usage{
corr2p(r, N)
}
\arguments{
\item{r}{a correlation coefficient}

\item{N}{a number of samples}
}
\value{
p a p-value
}
\description{
This functions converts an R value from a correlation calculation into a
p-value, using a T distribution with the provided number of samples N minus
2 degrees of freedom
}
\examples{
set.seed(1)
a<-rnorm(1000)
b<-a+rnorm(1000,sd=10)
r<-cor(a,b,method='pearson')
corr2p(r,N=length(a))
}
