% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{averageCond}
\alias{averageCond}
\title{Calculate mean over replicates}
\usage{
averageCond(data, NumReps, NumCond)
}
\arguments{
\item{data}{Matrix of data frame with numerical values. Columns corresponds
to samples}

\item{NumReps}{Number of replicates per experimental condition}

\item{NumCond}{Number of different experimental conditions}
}
\value{
Matrix of data frame with averaged values over replicates for each
conditions
}
\description{
Simple method to calculate the means for each feature across its replicates
}
\examples{
data <- matrix(rnorm(1000), nrow=100)
av_data <- averageCond(data, NumCond=2, NumReps=5)
}
