% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitMixedModelDE.R
\name{plotCompareP}
\alias{plotCompareP}
\title{Compare p-values from two analyses}
\usage{
plotCompareP(
  p1,
  p2,
  vpDonor,
  dupcorvalue,
  fraction = 0.2,
  xlabel = bquote(duplicateCorrelation ~ (-log[10] ~ p)),
  ylabel = bquote(dream ~ (-log[10] ~ p))
)
}
\arguments{
\item{p1}{p-value from first analysis}

\item{p2}{p-value from second analysis}

\item{vpDonor}{donor component for each gene from variancePartition analysis}

\item{dupcorvalue}{scalar donor component from duplicateCorrelation}

\item{fraction}{fraction of highest/lowest values to use for best fit lines}

\item{xlabel}{for x-axis}

\item{ylabel}{label for y-axis}
}
\value{
ggplot2 plot
}
\description{
Plot -log10 p-values from two analyses and color based on donor component from variancePartition analysis
}
\examples{

# load library
# library(variancePartition)

library(BiocParallel)

# load simulated data:
# geneExpr: matrix of gene expression values
# info: information/metadata about each sample
data(varPartData)

# Perform very simple analysis for demonstration

# Analysis 1
form <- ~Batch
fit <- dream(geneExpr, form, info)
fit <- eBayes(fit)
res <- topTable(fit, number = Inf, coef = "Batch3")

# Analysis 2
form <- ~ Batch + (1 | Tissue)
fit2 <- dream(geneExpr, form, info)
res2 <- topTable(fit2, number = Inf, coef = "Batch3")

# Compare p-values
plotCompareP(res$P.Value, res2$P.Value, runif(nrow(res)), .3)

}
