% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uSORT_main.R
\docType{package}
\name{uSORT}
\alias{uSORT}
\alias{uSORT-package}
\title{uSORT: A self-refining ordering pipeline for gene selection}
\usage{
uSORT(exprs_file, log_transform = TRUE, remove_outliers = TRUE,
  preliminary_sorting_method = c("autoSPIN", "sWanderlust", "monocle",
  "Wanderlust", "SPIN", "none"), refine_sorting_method = c("autoSPIN",
  "sWanderlust", "monocle", "Wanderlust", "SPIN", "none"),
  project_name = "uSORT", result_directory = getwd(), nCores = 1,
  save_results = TRUE, reproduce_seed = 1234,
  scattering_cutoff_prob = 0.75, driving_force_cutoff = NULL,
  qval_cutoff_featureSelection = 0.05, pre_data_type = c("linear",
  "cyclical"), pre_SPIN_option = c("STS", "neighborhood"),
  pre_SPIN_sigma_width = 1, pre_autoSPIN_alpha = 0.2,
  pre_autoSPIN_randomization = 20, pre_wanderlust_start_cell = NULL,
  pre_wanderlust_dfmap_components = 4, pre_wanderlust_l = 15,
  pre_wanderlust_num_waypoints = 150, pre_wanderlust_waypoints_seed = 2711,
  pre_wanderlust_flock_waypoints = 2, ref_data_type = c("linear",
  "cyclical"), ref_SPIN_option = c("STS", "neighborhood"),
  ref_SPIN_sigma_width = 1, ref_autoSPIN_alpha = 0.2,
  ref_autoSPIN_randomization = 20, ref_wanderlust_start_cell = NULL,
  ref_wanderlust_dfmap_components = 4, ref_wanderlust_l = 15,
  ref_wanderlust_num_waypoints = 150, ref_wanderlust_flock_waypoints = 2,
  ref_wanderlust_waypoints_seed = 2711)
}
\arguments{
\item{exprs_file}{Input file name in txt format, with rownames of cells and colnames of genes.}

\item{log_transform}{Boolean, if log transform the data.}

\item{remove_outliers}{Boolean, if remove the outliers.}

\item{preliminary_sorting_method}{Method name for preliminary sorting, including \code{autoSPIN}, \code{sWanderlust}, \code{monocle}, \code{Wanderlust}, \code{SPIN}, or \code{none}.}

\item{refine_sorting_method}{Method name for refined sorting, including \code{autoSPIN}, \code{sWanderlust}, \code{monocle}, \code{Wanderlust}, \code{SPIN}, or \code{none}.}

\item{project_name}{A character name as the prefix of the saved result file.}

\item{result_directory}{The directory indicating where to save the results.}

\item{nCores}{Number of cores that will be employed for drive gene selection (parallel computing), default is 1.}

\item{save_results}{Boolean determining if save the results.}

\item{reproduce_seed}{A seed used for reproducing the result.}

\item{scattering_cutoff_prob}{Scattering cutoff value probability for gene selection, default 0.75.}

\item{driving_force_cutoff}{Driving force cutoff value for gene selection, default NULL(automatically).}

\item{qval_cutoff_featureSelection}{Q value cutoff for gene selection, default 0.05.}

\item{pre_data_type}{The data type which guides the autoSPIN sorting, including \code{linear}, \code{cyclical}.}

\item{pre_SPIN_option}{SPIN contains two options including \code{STS}(default), \code{neighborhood}.}

\item{pre_SPIN_sigma_width}{Sigma width parameter for SPIN, default is 1.}

\item{pre_autoSPIN_alpha}{alpha parameter for autoSPIN, default is 0.2.}

\item{pre_autoSPIN_randomization}{Number of randomizations for autoSPIN, default is 20.}

\item{pre_wanderlust_start_cell}{The name of starting cell for wanderlust, default is the first cell from the data.}

\item{pre_wanderlust_dfmap_components}{Number of components from diffusion map used for wanderlust analysis, default is 4.}

\item{pre_wanderlust_l}{Number of nearest neighbors used for wanderlust, default is 15.}

\item{pre_wanderlust_num_waypoints}{Number of waypoint used for wanderlust, default is 150.}

\item{pre_wanderlust_waypoints_seed}{The seed for reproducing the wanderlust results.}

\item{pre_wanderlust_flock_waypoints}{The number of times for flocking the waypoints, default is 2.}

\item{ref_data_type}{The data type which guides the autoSPIN sorting, including \code{linear}, \code{cyclical}.}

\item{ref_SPIN_option}{SPIN contains two options including \code{STS}(default), \code{neighborhood}.}

\item{ref_SPIN_sigma_width}{Sigma width parameter for SPIN, default is 1.}

\item{ref_autoSPIN_alpha}{alpha parameter for autoSPIN, default is 0.2.}

\item{ref_autoSPIN_randomization}{Number of randomizations for autoSPIN, default is 20.}

\item{ref_wanderlust_start_cell}{The name of starting cell for wanderlust, default is the first cell from the data.}

\item{ref_wanderlust_dfmap_components}{Number of components from diffusion map used for wanderlust analysis, default is 4.}

\item{ref_wanderlust_l}{Number of nearest neighbors used for wanderlust, default is 15.}

\item{ref_wanderlust_num_waypoints}{Number of waypoint used for wanderlust, default is 150}

\item{ref_wanderlust_flock_waypoints}{The number of times for flocking the waypoints, default is 2.}

\item{ref_wanderlust_waypoints_seed}{The seed for reproducing the wanderlust results.}
}
\value{
results object (a list)
}
\description{
This package is designed to uncover the intrinsic cell progression path
from single-cell RNA-seq data.

The main function of \code{uSORT-pacakge} which provides a workflow of sorting scRNA-seq data.
}
\details{
This package incorporates data pre-processing, preliminary PCA gene selection, preliminary
cell ordering, feature selection, refined cell ordering, and post-analysis interpretation
and visualization. The uSORT workflow can be implemented through calling the main function or the GUI.
\code{\link{uSORT}}.
}
\examples{
dir <- system.file('extdata', package='uSORT')
file <- list.files(dir, pattern='.txt$', full=TRUE)
#remove the # symbol of the following codes to test
#uSORT_results <- uSORT(exprs_file = file, project_name = "test",
# preliminary_sorting_method = "autoSPIN",
# refine_sorting_method = "sWanderlust",
# save_results = FALSE)
}
\seealso{
\code{\link{uSORT-package}}, \code{\link{uSORT_GUI}}
}

