% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{whiteTheme}
\alias{whiteTheme}
\title{Use a theme with a white background and grey lines.}
\usage{
whiteTheme(legendPosition = "right", legendJustification = "center")
}
\arguments{
\item{legendPosition}{Where to position the legend. This can be "none",
"left", "right", "bottom", "top" or a numeric vector of length two. See the
documentation for \code{\link[ggplot2]{theme}}.}

\item{legendJustification}{The justification to use for the legend
positioning. This should be "center" or a two-element vector. Defaults to
"center".}
}
\value{
A \code{ggplot} theme layer.
}
\description{
The default \code{\link[ggplot2]{ggplot}} theme has a grey background. This
layer can be added to change the aesthetics.
}
\examples{
## Get a data frame in the right format.
aWell <- KRASdata[["E03"]]
aWell$Cluster <- relabelClasses(aWell, classCol="Cluster")

## Plot it with the white theme.
ggplot2::ggplot(aWell, ggplot2::aes(x=Ch2.Amplitude, y=Ch1.Amplitude)) +
  ggplot2::geom_point(ggplot2::aes(colour=Cluster)) +
  whiteTheme()

}
\seealso{
This function uses \code{\link[ggplot2]{theme}}.
}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
