% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isTwoDimDataFrame.R
\name{setChannelNames}
\alias{setChannelNames}
\alias{setChannelNames,data.frame-method}
\alias{setChannelNames,list-method}
\title{Rename the channels.}
\usage{
setChannelNames(droplets, ch1 = "Ch1.Amplitude", ch2 = "Ch2.Amplitude")

\S4method{setChannelNames}{data.frame}(droplets, ch1 = "Ch1.Amplitude", ch2 = "Ch2.Amplitude")

\S4method{setChannelNames}{list}(droplets, ch1 = "Ch1.Amplitude", ch2 = "Ch2.Amplitude")
}
\arguments{
\item{droplets}{A data frame or list of data frames. Each data frame should
have at least two columns, where the first two columns should be vectors of
doubles.}

\item{ch1}{The channel 1 label.}

\item{ch2}{The channel 2 label.}
}
\value{
The object \code{droplets} with the channels renamed.
}
\description{
We use the channel names "Ch1.Amplitude" and "Ch2.Amplitude" by default.
This method allows us to change it at will.
}
\examples{
## Ensure that a data frame has channels named "Ch1.Amplitude" and
## "Ch2.Amplitude".
aWell <- KRASdata[["E03"]]
aWell <- setChannelNames(aWell)
colnames(aWell)

## Perhaps we want to abbreviate the channel names.
aWell <- setChannelNames(aWell, "Ch1", "Ch2")
colnames(aWell)

## The same operator works for a list of data frames.
krasWells <- KRASdata
krasWells <- setChannelNames(krasWells, "Ch1", "Ch2")
lapply(krasWells, colnames)[1:3]

}
