% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise.R
\name{renormalisePlate}
\alias{renormalisePlate}
\title{Normalise all wells in a plate to the overall/average cluster
positions.}
\usage{
renormalisePlate(
  plate,
  initialCentres = matrix(c(0, 0, 10000, 0, 0, 7000, 10000, 7000), ncol = 2, byrow =
    TRUE),
  minSeparation = 2000
)
}
\arguments{
\item{plate}{A \code{ddpcrPlate} object.}

\item{initialCentres}{A matrix or data frame of (rough estimates) of centres
of each of the clusters in the combined data. This will be used for an
initial run of k-means clustering.}

\item{minSeparation}{The minimum distance required between two cluster
centres in order for us to assume that k-means clustering found two distinct
clusters. This is used when classifying droplets along a single channel and
helps to reject classifications where there is only one cluster, e.g. when
there are no mutants in a well. Defaults to 2000.}
}
\value{
A list of data frames with the rescaled amplitudes in both channels.
}
\description{
Each well is scaled in the direction of the two axes
independently. The algorithm works as follows:
\enumerate{
  \item Classify the entire plate using k-means clustering in order to
    roughly identify clusters.
  \item For each channel and each well:
    \enumerate{
      \item Remove the positive clusters in the other channel.
      \item Re-run k-means clustering with \eqn{k = 2} to obtain new
        cluster centres. If the centres are too close (default distance
        2000), reject these new cluster centres and use the old centres.
      \item Use the new centres for each well to rescale to the same scale
      as the average/overall scale.
    }
}
}
\examples{
## Normalise the KRAS data.
plate <- ddpcrPlate(wells=KRASdata)
normPlate <- renormalisePlate(plate)

}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
