% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatPlot.R
\name{heatPlot}
\alias{heatPlot}
\alias{densityPlot}
\alias{heatPlot,data.frame-method}
\alias{heatPlot,ddpcrWell-method}
\alias{heatPlot,ddpcrPlate-method}
\title{Draw a heat plot of the droplets.}
\usage{
heatPlot(
  droplets,
  ch1Label = "Ch1 Amplitude",
  ch2Label = "Ch2 Amplitude",
  binwidth = 100,
  plotLimits = list(x = c(1000, 9000), y = c(3000, 13500))
)

heatPlot(
  droplets,
  ch1Label = "Ch1 Amplitude",
  ch2Label = "Ch2 Amplitude",
  binwidth = 100,
  plotLimits = list(x = c(1000, 9000), y = c(3000, 13500))
)

\S4method{heatPlot}{data.frame}(
  droplets,
  ch1Label = "Ch1 Amplitude",
  ch2Label = "Ch2 Amplitude",
  binwidth = 100,
  plotLimits = list(x = c(1000, 9000), y = c(3000, 13500))
)

\S4method{heatPlot}{ddpcrWell}(
  droplets,
  ch1Label = "Ch1 Amplitude",
  ch2Label = "Ch2 Amplitude",
  binwidth = 100,
  plotLimits = list(x = c(1000, 9000), y = c(3000, 13500))
)

\S4method{heatPlot}{ddpcrPlate}(
  droplets,
  ch1Label = "Ch1 Amplitude",
  ch2Label = "Ch2 Amplitude",
  binwidth = 100,
  plotLimits = list(x = c(1000, 9000), y = c(3000, 13500))
)
}
\arguments{
\item{droplets}{A data frame of droplet amplitudes, a \code{ggplot},
\code{ddpcrWell} or \code{ddpcrPlate} object.}

\item{ch1Label}{The label for the channel 1 target. Defaults to "Ch1
Amplitude".}

\item{ch2Label}{The label for the channel 2 target. Defaults to "Ch2
Amplitude".}

\item{binwidth}{The width of each hexagonal bin in the 2d heat (density)
plot. Defaults to 100.}

\item{plotLimits}{A list of 2-element vectors with names \code{x} and
\code{y}. These are used to fix the x and y limits of the plot, which is
especially useful for comparing plots. Defaults to \code{list(x=c(1000,
9000), y=c(3000, 13500))}.}
}
\value{
A heat plot as a \code{\link[ggplot2]{ggplot}} object.
}
\description{
Using alpha transparency only, it is generally difficult to see
where droplets are truly distributed and concentrated. A heat (density) plot
gives a better illustration of this.
}
\examples{
## Density plot of a data frame.
heatPlot(KRASdata[["E03"]])

## Density plot of a ddpcrWell object.
aWell <- ddpcrWell(well=KRASdata[["E03"]])
heatPlot(aWell)

## Density plot of a ddpcrPlate object with an adjusted bin size.
krasPlate <- ddpcrPlate(wells=KRASdata)
heatPlot(krasPlate, binwidth=50)

}
\references{
The nice log-scaled palette was achieved using
\url{http://www.everydayanalytics.ca/2014/09/5-ways-to-do-2d-histograms-in-r.html}
}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
