% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddpcrPlate.R
\docType{class}
\name{ddpcrPlate-class}
\alias{ddpcrPlate-class}
\alias{.ddpcrPlate}
\alias{ddpcrPlate}
\alias{ddpcrPlate,list-method}
\alias{ddpcrPlate,ddpcrPlate-method}
\alias{ddpcrPlate,character-method}
\alias{ddpcrPlate,missing-method}
\alias{show,ddpcrPlate-method}
\title{An S4 class for multiple wells in a ddPCR experiment.}
\usage{
ddpcrPlate(wells)

\S4method{ddpcrPlate}{list}(wells)

\S4method{ddpcrPlate}{ddpcrPlate}(wells)

\S4method{ddpcrPlate}{character}(wells)

\S4method{ddpcrPlate}{missing}(wells)

\S4method{show}{ddpcrPlate}(object)
}
\arguments{
\item{wells}{Either:
\itemize{
  \item a list of \code{\link{ddpcrWell}} objects,
  \item a list of data frames of droplet amplitudes, or
  \item a character vector corresponding to a file path(s) containing CSV
  files of raw droplet amplitude data.
}}

\item{object}{Any R object}
}
\value{
A \code{ddpcrPlate} object with the given wells.
}
\description{
An S4 class for multiple wells in a ddPCR experiment.

The constructor for the \code{ddpcrPlate} class.
}
\examples{
## A \code{ddpcrPlate} object can be created from data from a list of data
## frames.
ddpcrPlate(KRASdata)

## A directory (or individual files) of droplet amplitude CSVs can also be
## loaded.
moreAmpsDir <- system.file("extdata", "more-amplitudes", package="twoddpcr")
ddpcrPlate(moreAmpsDir)

}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}

Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
