% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterCentres.R
\name{clusterCentres}
\alias{clusterCentres}
\alias{clusterCenters}
\alias{wellCentres}
\alias{wellCenters}
\alias{clusterCentres,ddpcrWell-method}
\alias{clusterCentres,ddpcrPlate-method}
\alias{plateCentres}
\alias{plateCenters}
\alias{combinedCentres}
\alias{combinedCenters}
\alias{combinedPlateCentres}
\alias{combinedPlateCenters}
\alias{combinedCentres,ddpcrPlate-method}
\title{Retrieve the cluster centres.}
\usage{
clusterCentres(theObject, cMethod)

\S4method{clusterCentres}{ddpcrWell}(theObject, cMethod)

\S4method{clusterCentres}{ddpcrPlate}(theObject, cMethod)

combinedCentres(theObject, cMethod)

\S4method{combinedCentres}{ddpcrPlate}(theObject, cMethod)
}
\arguments{
\item{theObject}{A \code{\link{ddpcrWell}} or \code{\link{ddpcrPlate}}
object.}

\item{cMethod}{The classification method for which to obtain the centres.}
}
\value{
If a \code{ddpcrWell} object is given, \code{clusterCentres} returns
the cluster centres as a data frame.

If a \code{ddpcrPlate} object is given, \code{clusterCentres} return
a list of data frames, where each data frame corresponds to the cluster
centres of a well.

\code{combinedCentres} returns a data frame of the centres of all of
the wells combined.
}
\description{
\code{clusterCentres} retrieves the cluster centres for
a \code{\link{ddpcrWell}} object or the centres for each well in
a \code{\link{ddpcrPlate}} object.

\code{combinedCentres} retrieves the cluster centres for all of
the wells together.
}
\examples{
## Get the centres of a sample with 4 clusters.
aWell <- ddpcrWell(well=KRASdata[["E03"]])
clusterCentres(aWell, "Cluster")

## Get the centres of a sample with 3 clusters.
aWell <- ddpcrWell(well=KRASdata[["H04"]])
clusterCentres(aWell, "Cluster")

## Retrieve the cluster centres of each of the wells in a \code{ddpcrPlate}
## object.
krasPlate <- ddpcrPlate(wells=KRASdata)
clusterCentres(krasPlate, cMethod="Cluster")

## Retrieve the cluster centres of all wells combined.
combinedCentres(krasPlate, cMethod="Cluster")

}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
