% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterStats.R
\name{classStats}
\alias{classStats}
\title{Get some basic statistical properties for each class.}
\usage{
classStats(droplets, classCol = "class")
}
\arguments{
\item{droplets}{A data frame of droplets with \code{Ch1.Amplitude} and
\code{Ch2.Amplitude} columns, as well as a class column (see the parameter
\code{classCol}).}

\item{classCol}{The column (name or number) from \code{droplets}
representing the class.}
}
\value{
A list (grouped by class name) of lists with keys \code{mean},
\code{cov} and \code{cov.inv}. If \code{cov} is a singular matrix, then
\code{cov.inv} will be \code{NULL}.
}
\description{
This function gives the mean, covariance and inverse of the covariance for
each of the classes.
}
\examples{
## Get some basic statistical properties of the clusters.
aWell <- KRASdata[["E03"]]
aWell$Cluster <- relabelClasses(aWell, classCol="Cluster")
classStats(aWell, classCol="Cluster")

## We repeat the above but with a sample with no "PP" cluster.
aWell <- KRASdata[["H04"]]
aWell$Cluster <- relabelClasses(aWell, classCol="Cluster")
classStats(aWell, classCol="Cluster")

}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
