% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlapsByVar.R
\name{overlapsByVar}
\alias{overlapsByVar}
\alias{overlapsByVar,GRangesList,GRanges-method}
\alias{overlapsByVar-methods}
\alias{overlapsByVar,GRanges,GRanges-method}
\title{Count overlaps by variant type}
\usage{
overlapsByVar(x, var, ...)

\S4method{overlapsByVar}{GRangesList,GRanges}(x, var, alt_col = "ALT", ...)

\S4method{overlapsByVar}{GRanges,GRanges}(x, var, alt_col = "ALT", ...)
}
\arguments{
\item{x}{A GRangesList with features of interest}

\item{var}{A Granges object with variants of interest}

\item{...}{Passed to \link{rowSums}}

\item{alt_col}{The column within mcols(var) which contains the alternate
allele}
}
\value{
A vector or matrix
}
\description{
Count how many variants of each type overlap ranges
}
\details{
Taking any GRanges or GRangesList, count how many of each variant type
overlap a region.
}
\examples{
library(rtracklayer)
library(VariantAnnotation)
gtf <- import.gff(
    system.file("extdata/gencode.v44.subset.gtf.gz", package = "transmogR")
)
grl <- splitAsList(gtf, gtf$type)
vcf <- system.file("extdata/1000GP_subset.vcf.gz", package = "transmogR")
var <- rowRanges(readVcf(vcf, param = ScanVcfParam(fixed = "ALT")))
overlapsByVar(grl, var)

}
