% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllMethods.R
\docType{methods}
\name{clusterVisualization}
\alias{clusterVisualization}
\alias{clusterVisualization,Transcriptogram-method}
\alias{clusterVisualization-method}
\title{Displays graphs of the differentially expressed clusters}
\usage{
clusterVisualization(object, maincomp = FALSE, connected = FALSE,
  host = "127.0.0.1", port = 9091, clusters = NULL,
  onlyGenesInDE = FALSE, colors = NULL)

\S4method{clusterVisualization}{Transcriptogram}(object,
  maincomp = FALSE, connected = FALSE, host = "127.0.0.1",
  port = 9091, clusters = NULL, onlyGenesInDE = FALSE,
  colors = NULL)
}
\arguments{
\item{object}{An object of class Transcriptogram.}

\item{maincomp}{Logical value, set as TRUE if you want to display only the main component of
each cluster. The default value of this argument is FALSE.}

\item{connected}{Logical value, set as TRUE if you want to display only connected nodes.
The default value of this argument is FALSE.}

\item{host}{The domain name of the machine that is running the RedeR XML-RPC
server.}

\item{port}{An integer specifying the port on which the XML-RPC server should
listen.}

\item{clusters}{An integer vector specifying the clusters to be
displayed. If NULL, all clusters will be displayed.}

\item{onlyGenesInDE}{Logical value, set as TRUE to use only the genes
in the DE slot. Set as FALSE to use all the genes referring to the positions
in the clusters slot. The default value of this argument is FALSE.}

\item{colors}{Color vector used to distinguish the clusters. If NULL, the rainbow palette will be used
to generate the colors. The color vector must contain a color for each cluster.}
}
\value{
This method returns an object of the RedPort Class.
}
\description{
This method uses the \pkg{RedeR} package to display graphs of the
differentially expressed clusters.
}
\details{
RedeR package requirements: Java Runtime Environment (>= 6).
}
\examples{
transcriptogram <- transcriptogramPreprocess(association, Hs900, 50)
\dontrun{
transcriptogram <- transcriptogramStep1(transcriptogram, GSE9988, GPL570)
transcriptogram <- transcriptogramStep2(transcriptogram)
levels <- c(rep(FALSE, 3), rep(TRUE, 3))
transcriptogram <- differentiallyExpressed(transcriptogram, levels, 0.01,
DEsymbols)
rdp <- clusterVisualization(transcriptogram)
}

}
\seealso{
\link[transcriptogramer:differentiallyExpressed-method]{differentiallyExpressed},
\link[transcriptogramer]{transcriptogramPreprocess},
\link[transcriptogramer]{GSE9988},
\link[transcriptogramer]{GPL570},
\link[transcriptogramer]{Hs900},
\link[transcriptogramer]{association},
\link[transcriptogramer:transcriptogramStep1-method]{transcriptogramStep1},
\link[transcriptogramer:transcriptogramStep2-method]{transcriptogramStep2},
\link[RedeR]{RedPort}
}
\author{
Diego Morais
}
