% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChipDataSet-generics.R, R/ChipDataSet-methods.R
\docType{methods}
\name{predictTssOverlap}
\alias{predictTssOverlap}
\alias{predictTssOverlap,ChipDataSet-method}
\title{predictTssOverlap}
\usage{
predictTssOverlap(object, feature, p = 0.8)

\S4method{predictTssOverlap}{ChipDataSet}(object, feature, p = 0.8)
}
\arguments{
\item{object}{A \code{\link{ChipDataSet}} object.}

\item{feature}{\code{Character}. Specify feature(s) that are be used as
predictors in the classification model. By default, all the features
stored in the \code{\link{ChipDataSet}} object will be used.}

\item{p}{\code{Numeric}. The proportion of data that is used to train the
model. Default: 0.8.}
}
\value{
The slot \code{tssOverlapPrediction} of the provided
    \code{TranscriptionDataSet} object will be updated by the the following
    elements: 'predicted.tssOverlap', 'confusionMatrix', 'logFitSummary' and
    'roc'.
}
\description{
The function classifies ChIP-seq peaks on gene associated and background using
classification model based on a logistic regression.
}
\details{
In order to improve the accuracy of the model the data is internally
    partitioned into a training and testing data sets. A repeated 10-Fold
    Cross-Validation is used to calculate performance measures on the
    training data set and to prevent over-fitting.

    The model fit and validation is internally acomplised by the functions
    implemented in the \href{http://topepo.github.io/caret/index.html}{caret}
    package.
}
\examples{
### Load ChipDataSet object
data(cds)

predictTssOverlap(object = cds, feature = "pileup", p = 0.75)

### View a short summary of the gene associated peaks prediction
cds

### View peaks and associated prediction
getPeaks(cds)

}
\seealso{
\code{\link{ChipDataSet}}
    \code{\link{constructCDS}}
    \href{http://topepo.github.io/caret/index.html}{caret}
}
\author{
Armen R. Karapetyan
}
