% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChipDataSet-class.R
\docType{class}
\name{ChipDataSet-class}
\alias{ChipDataSet}
\alias{ChipDataSet-class}
\title{ChipDataSet}
\description{
The \code{ChipDataSet} is a S4 class to store input values, intermediate
calculations and results of ChIP-seq peaks analysis.
}
\section{Slots}{

\describe{
\item{\code{peaks}}{\code{\link[GenomicRanges]{GRanges}}. ChIP-seq peaks.}

\item{\code{region}}{\code{\link[GenomicRanges]{GRanges}}. Genomic region(s) to extract peaks from.}

\item{\code{genomicAnnotation}}{\code{Data.Frame}. Genomic distribution of the peaks
at distinct genomic features (TSSs, exons, introns, intergenic regions).}

\item{\code{features}}{\code{Data.Frame}. Estimated characteristics (features) of the
peaks.}

\item{\code{tssOverlapPrediction}}{\code{List}. Prediction of the gene associated
peaks. The following elements are reported:
\itemize{
    \item 'predicted.tssOverlap' - predicted class (yes - gene associated;
        no - background) and probability of a ChIP-seq peak being
        classified as gene associated.
    \item 'confusionMatrix' - cross-tabulation of observed and predicted
        classes with associated statistics.
    \item 'logFitSummary' - statistical significance of the predictors
        used in the logistic regression.
    \item 'roc' - results of the receiver operating characteristic
        analysis.
    }}

\item{\code{strandPrediction}}{\code{List}. Prediction of the peak strandedness. The
following elements are reported:
\itemize{
    \item 'predicted.strand' - predicted ChIP-seq peak strand.
    \item 'probability.cutoff' - probability cutoff for q2.
    \item 'results.plus' - intermediate calculations for the forward DNA
        strand.
    \item 'results.minus' - intermediate calculations for the reverse DNA
        strand.
    }}
}}
\author{
Armen R. Karapetyan
}
\seealso{
\code{\link{constructCDS}}
    \code{\link{predictTssOverlap}}
    \code{\link{predictStrand}}
}

