#' A list of GAM models, used to demonstrate the various tests.
#'
#' A list of 11 \code{\link{gamObject}} obtained by fitting 10 genes on 15
#' cells randomly assigned to lineages with random pseudotimes.
#'
#' @format Can be re-obtained by runing the code in the example section
#'  of \code{\link{fitGAM}}.
#' @usage data(gamList)
"gamList"


#' A SlingshotDataset object, used in the package unit tests.
#'
#' This dataset contains the toy example from the Slingshot R package vignette.
#'
#' @source \url{https://bioconductor.org/packages/release/bioc/html/slingshot.html}
#' @usage data(sds)
"sds"

#' A SlingshotDataset object, used in the package vignette.
#'
#' This dataset contains the Slingshot trajectory from the data described in
#' Paul et al. (2015).
#'
#' @references
#' Franziska Paul, Yaara Arkin, Amir Giladi, DiegoAdhemar Jaitin, Ephraim Kenigsberg, Hadas KerenShaul, Deborah Winter, David Lara-Astiaso, Meital Gury, Assaf Weiner, Eyal David, Nadav Cohen,
#' FeliciaKathrineBratt Lauridsen, Simon Haas, Andreas Schlitzer, Alexander Mildner, Florent Ginhoux,
#' Steen Jung, Andreas Trumpp, BoTorben Porse, Amos Tanay, and Ido Amit. Transcriptional Heterogeneity and Lineage Commitment in Myeloid Progenitors. Cell, 163(7):1663–1677, 12 2015. ISSN 0092-
#' 8674. doi: 10.1016/J.CELL.2015.11.013. URL https://www.sciencedirect.com/science/article/
#' ii/S0092867415014932?via%3Dihub#app3.
#' @usage data(crv)
"crv"

#' A count matrix, used in the package vignette.
#'
#' This object contains the gene expression counts from the data described in
#' Paul et al. (2015).
#'
#' #' @references
#' Franziska Paul, Yaara Arkin, Amir Giladi, DiegoAdhemar Jaitin, Ephraim Kenigsberg, Hadas KerenShaul, Deborah Winter, David Lara-Astiaso, Meital Gury, Assaf Weiner, Eyal David, Nadav Cohen,
#' FeliciaKathrineBratt Lauridsen, Simon Haas, Andreas Schlitzer, Alexander Mildner, Florent Ginhoux,
#' Steen Jung, Andreas Trumpp, BoTorben Porse, Amos Tanay, and Ido Amit. Transcriptional Heterogeneity and Lineage Commitment in Myeloid Progenitors. Cell, 163(7):1663–1677, 12 2015. ISSN 0092-
#' 8674. doi: 10.1016/J.CELL.2015.11.013. URL https://www.sciencedirect.com/science/article/
#' ii/S0092867415014932?via%3Dihub#app3.
#' @usage data(countMatrix)
"countMatrix"


#' A vector defining cell types, used in the package vignette.
#'
#' This object contains a vector that define the cell type for each cell in
#' the data described in Paul et al. (2015).
#'
#' #' @references
#' Franziska Paul, Yaara Arkin, Amir Giladi, DiegoAdhemar Jaitin, Ephraim Kenigsberg, Hadas KerenShaul, Deborah Winter, David Lara-Astiaso, Meital Gury, Assaf Weiner, Eyal David, Nadav Cohen,
#' FeliciaKathrineBratt Lauridsen, Simon Haas, Andreas Schlitzer, Alexander Mildner, Florent Ginhoux,
#' Steen Jung, Andreas Trumpp, BoTorben Porse, Amos Tanay, and Ido Amit. Transcriptional Heterogeneity and Lineage Commitment in Myeloid Progenitors. Cell, 163(7):1663–1677, 12 2015. ISSN 0092-
#' 8674. doi: 10.1016/J.CELL.2015.11.013. URL https://www.sciencedirect.com/science/article/
#' ii/S0092867415014932?via%3Dihub#app3.
#' @usage data(celltype)
"celltype"
