% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{maketracktable}
\alias{maketracktable}
\title{Make HTML pages for IGV sessions (Tracktables Experiment Report)}
\usage{
maketracktable(fileSheet, SampleSheet, filename, basedirectory, genome,
  colourBy = NULL, igvParams = igvParam())
}
\arguments{
\item{fileSheet}{A data frame containing sample file locations (e.g. BigWig locations).}

\item{SampleSheet}{A data frame containing sample metadata}

\item{filename}{Character of name for tracktables HTML report. (.html prefix is added automatically)}

\item{basedirectory}{Character of directory for tracktables HTML report, IGV sessions and any interval files}

\item{genome}{Character of genome for IGV (See IGV user guide for details)}

\item{colourBy}{Character defining which sample metadata to be used for colouring bigwig files}

\item{igvParams}{An object of class igvParam containing display parameters for IGV.
When providing a list, this list must be same length as number of samples and each element have two numeric values corresponding to minimum
and maximum value to be used in setting data range. Currently only "autoscale" or a list of minimum and maximum values are accepted.}
}
\value{
An object containing XML document (HTMLInternalDocument,XMLInternalDocument,XMLAbstractDocument)
}
\description{
Creates HTML table of sample metadata and all required files for interacting with IGV.
}
\examples{
fileLocations <- system.file("extdata",package="tracktables")

bigwigs <- dir(fileLocations,pattern="*.bw",full.names=TRUE)

intervals <- dir(fileLocations,pattern="*.bed",full.names=TRUE)

bigWigMat <- cbind(gsub("_Example.bw","",basename(bigwigs)),
                   bigwigs)

intervalsMat <- cbind(gsub("_Peaks.bed","",basename(intervals)),
                      intervals)

fileSheet <- merge(bigWigMat,intervalsMat,all=TRUE)

fileSheet <- as.matrix(cbind(fileSheet,NA))

colnames(fileSheet) <- c("SampleName","bigwig","interval","bam")

SampleSheet <- cbind(as.vector(fileSheet[,"SampleName"]),
                     c("EBF","H3K4me3","H3K9ac","RNAPol2"),
                     c("ProB","ProB","ProB","ProB"))

colnames(SampleSheet) <- c("SampleName","Antibody","Species")
  HTMLreport <- maketracktable(fileSheet,SampleSheet,
                               "IGV_Example.html",
                               basedirectory=getwd(),
                               "mm9")
}
\author{
Thomas Carroll
}

