% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{linePlot}
\alias{linePlot}
\title{Line plot for expression traces}
\usage{
linePlot(object, genes, matrix = "normalized", facet = FALSE, span = 0.3)
}
\arguments{
\item{object}{A \code{SummarizedExperiment} object.}

\item{genes}{A character vector of gene names for plotting expression traces.}

\item{matrix}{Character, must be one of \code{"count"}, \code{"normalized"}, or \code{"scaled"}.}

\item{facet}{Logical. Plot the expression trace of each gene in a facet if it is \code{TRUE}.}

\item{span}{Numeric, the amount of smoothing for the default loess smoother. Smaller numbers produce wigglier lines, larger numbers produce smoother lines. Set it to 0 for non-smoothing lines.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot expression traces for genes across sections in a \code{SummarizedExperiment} object.
}
\examples{
data(zh.data)
zh <- createTomo(zh.data)
linePlot(zh,
 c("ENSDARG00000002131", "ENSDARG00000003061", "ENSDARG00000076075", "ENSDARG00000076850"))

# Do not smooth lines.
linePlot(zh,
 c("ENSDARG00000002131", "ENSDARG00000003061", "ENSDARG00000076075", "ENSDARG00000076850"), span=0)

# Plot genes in different facets.
linePlot(zh,
 c("ENSDARG00000002131", "ENSDARG00000003061", "ENSDARG00000076075", "ENSDARG00000076850"),
 facet=TRUE)
}
\seealso{
\code{geom_smooth} for plotting smooth lines, \code{facet_wrap} for faceting genes.
}
