% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{hierarchClust}
\alias{hierarchClust}
\title{Hierarchical clustering across sections}
\usage{
hierarchClust(
  object,
  matrix = "normalized",
  measure = "euclidean",
  p = 2,
  agglomeration = "complete"
)
}
\arguments{
\item{object}{A \code{SummarizedExperiment} object.}

\item{matrix}{Character, must be one of \code{"count"}, \code{"normalized"}, or \code{"scaled"}.}

\item{measure}{Character, must be one of \code{"euclidean"}, \code{"maximum"}, \code{"manhattan"}, \code{"canberra"}, \code{"binary"} or \code{"minkowski"}.}

\item{p}{Numeric, the power of the Minkowski distance.}

\item{agglomeration}{Character, must be one of \code{"ward.D"}, \code{"ward.D2"}, \code{"single"}, \code{"complete"}, \code{"average"}, \code{"mcquitty"}, \code{"median"} or \code{"centroid"}.}
}
\value{
A \code{hclust} object.
}
\description{
Performs hierarchical clustering across sections in a \code{SummarizedExperiment} object.
}
\examples{
data(zh.data)
zh <- createTomo(zh.data)
hclust_zh <- hierarchClust(zh)
plot(hclust_zh)

# Use other agglomeration method
hclust_zh <- hierarchClust(zh, agglomeration="average")

# (Not recommended) Use scaled read counts to calculate distance
zh <- scaleTomo(zh)
hclust_zh <- hierarchClust(zh, matrix="scaled")
}
\seealso{
\code{\link[stats]{dist}} for measuring distance and \code{\link[stats]{hclust}} for performing hierarchical clustering on a matrix.
}
