% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bibliography.R
\docType{methods}
\name{get_bibliography}
\alias{get_bibliography}
\alias{get_bibliography,SummarizedExperiment-method}
\alias{get_bibliography,RangedSummarizedExperiment-method}
\title{Produces the bibliography list of your workflow}
\usage{
get_bibliography(.data)

\S4method{get_bibliography}{SummarizedExperiment}(.data)

\S4method{get_bibliography}{RangedSummarizedExperiment}(.data)
}
\arguments{
\item{.data}{A `tbl` (with at least three columns for sample, feature and transcript abundance) or `SummarizedExperiment` (more convenient if abstracted to tibble with library(tidySummarizedExperiment))}
}
\value{
NULL. It prints a list of bibliography references for the software used through the workflow.

A consistent object (to the input) with additional columns for the statistics from the hypothesis test (e.g.,  log fold change, p-value and false discovery rate).

A consistent object (to the input) with additional columns for the statistics from the hypothesis test (e.g.,  log fold change, p-value and false discovery rate).
}
\description{
get_bibliography() takes as input a `tidybulk`
}
\details{
`r lifecycle::badge("maturing")`

This methods returns the bibliography list of your workflow from the metadata of a tidybulk object (metadata(.)$tidybulk$methods_used) or from the internals for backward compatibility (attr(., "internals"))
}
\examples{
## Load airway dataset for examples

  data('airway', package = 'airway')
  # Ensure a 'condition' column exists for examples expecting it

    SummarizedExperiment::colData(airway)$condition <- SummarizedExperiment::colData(airway)$dex




get_bibliography(airway)

}
\references{
Mangiola, S., Molania, R., Dong, R., Doyle, M. A., & Papenfuss, A. T. (2021). tidybulk: an R tidy framework for modular transcriptomic data analysis. Genome Biology, 22(1), 42. doi:10.1186/s13059-020-02233-7
}
