% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename.R
\name{rename}
\alias{rename}
\alias{rename.SummarizedExperiment}
\title{Rename columns}
\usage{
\method{rename}{SummarizedExperiment}(.data, ...)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{For \code{rename()}: <\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Use
\code{new_name = old_name} to rename selected variables.

For \code{rename_with()}: additional arguments passed onto \code{.fn}.}
}
\value{
An object of the same type as \code{.data}. The output has the following
properties:
\itemize{
\item Rows are not affected.
\item Column names are changed; column order is preserved.
\item Data frame attributes are preserved.
\item Groups are updated to reflect new names.
}
}
\description{
\code{rename()} changes the names of individual variables using
\code{new_name = old_name} syntax; \code{rename_with()} renames columns using a
function.
}
\section{Methods}{


This function is a \strong{generic}, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.

The following methods are currently available in loaded packages:
\Sexpr[stage=render,results=rd]{dplyr:::methods_rd("rename")}.

}

\examples{
data(pasilla)
pasilla |> rename(cond=condition)

}
\references{
Hutchison, W.J., Keyes, T.J., The tidyomics Consortium. et al. The tidyomics ecosystem: enhancing omic data analyses. Nat Methods 21, 1166–1170 (2024). https://doi.org/10.1038/s41592-024-02299-2

Wickham, H., François, R., Henry, L., Müller, K., Vaughan, D. (2023). dplyr: A Grammar of Data Manipulation. R package version 2.1.4, https://CRAN.R-project.org/package=dplyr
}
\seealso{
Other single table verbs: 
\code{\link{mutate}()},
\code{\link{slice}()},
\code{\link{summarise}()}
}
\concept{single table verbs}
