% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_verbs.R
\name{slice_head.flowFrame}
\alias{slice_head.flowFrame}
\title{Subset rows at the head of a data structure.}
\usage{
\method{slice_head}{flowFrame}(.data, ..., n, prop, by = NULL)
}
\arguments{
\item{.data}{A \code{\link[flowCore]{flowFrame}}}

\item{...}{Unused.}

\item{n, prop}{Provide either n, the number of rows, or prop, the proportion
of rows to select. If neither are supplied, n = 1 will be used.
If n is greater than the number of rows in the group (or prop > 1), the
result will be silently truncated to the group size. prop will be rounded
towards zero to generate an integer number of rows.

A negative value of n or prop will be subtracted from the group size.
For example, n = -2 with a group of 5 rows will select 5 - 2 = 3 rows;
prop = -0.25 with 8 rows will select 8 * (1 - 0.25) = 6 rows.}

\item{by}{Optionally, an unquoted selection of columns to group by for just this operation.
An alternative to group_by.}
}
\value{
An object of the same type as .data. The output has the following properties:
* Each row may appear 0, 1, or many times in the output.
* Columns are not modified.
* Groups are not modified.
* A \code{\link[flowCore]{flowFrame}}'s \code{\link[flowCore]{identifier}} is preserved.
}
\description{
Subset rows at the head of a data structure.
}
\examples{

my_flowframe <- simulate_cytometry_data()$flowframe

 my_flowframe |>
   dplyr::slice_head(n = 5)

}
