% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_verbs.R
\name{count.flowSet}
\alias{count.flowSet}
\title{Count the observations in each group.}
\usage{
\method{count}{flowSet}(x, ..., wt = NULL, sort = FALSE, name = NULL)
}
\arguments{
\item{x}{A \code{\link[flowCore]{flowSet}}}

\item{...}{Variables to group by, named according to
\code{\link[flowCore]{featureNames}} or the columns of the flowSet's
\code{\link[Biobase]{pData}}}

\item{wt}{If NULL (the default), counts the number of rows in each group.
If a variable, computes sum(wt) for each group.}

\item{sort}{If TRUE, will show the largest groups at the top.}

\item{name}{If omitted, it will default to n. If there's already a column
called n, it will use nn. If there's a column called n and nn, it'll use nnn,
and so on, adding ns until it gets a new name.}
}
\value{
A data.frame containing the groupwise counts. If no columns are
specified in `...`, the grouping is performed by experiment in the flowSet.
Otherwise, the columns specified by `...` will be used for grouping.
}
\description{
Count the observations in each group.
}
\examples{
my_flowset <- simulate_cytometry_data()$flowset

my_flowset |>
  dplyr::count()

my_flowset |>
  dplyr::count(cell_type)


}
