% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tRNAdbImport-import.R
\docType{data}
\name{import.tRNAdb}
\alias{import.tRNAdb}
\alias{import.mttRNAdb}
\alias{import.tRNAdb.id}
\alias{import.mttRNAdb.id}
\alias{import.tRNAdb.blast}
\alias{import.mttRNAdb.blast}
\alias{tRNAdb2GFF}
\alias{TRNA_DB_URL}
\alias{TRNA_DB_URL_MT}
\title{Importing information from the tRNA db as GRanges object}
\format{
An object of class \code{character} of length 1.

An object of class \code{character} of length 1.
}
\usage{
TRNA_DB_URL

TRNA_DB_URL_MT

import.tRNAdb.id(
  tdbID,
  database = c("DNA", "RNA"),
  origin = c("allothers", "plastid", "mitochondrial"),
  dbURL = TRNA_DB_URL,
  verbose = FALSE
)

import.mttRNAdb.id(mtdbID, dbURL = TRNA_DB_URL_MT, verbose = FALSE)

import.tRNAdb.blast(
  blastSeq,
  database = c("DNA", "RNA"),
  origin = c("allothers", "plastid", "mitochondrial"),
  dbURL = TRNA_DB_URL,
  verbose = FALSE
)

import.tRNAdb(
  organism = "",
  strain = "",
  taxonomyID = "",
  aminoacids = "",
  anticodons = "",
  sequences = list(),
  structures = list(),
  reference = "",
  comment = "",
  pubmed = "",
  genes = "",
  database = c("DNA", "RNA"),
  origin = c("allothers", "plastid", "mitochondrial"),
  dbURL = TRNA_DB_URL,
  verbose = FALSE
)

import.mttRNAdb(
  organism = "",
  strain = "",
  taxonomyID = "",
  aminoacids = "",
  anticodons = "",
  sequences = list(),
  structures = list(),
  reference = "",
  comment = "",
  pubmed = "",
  genes = "",
  dbURL = TRNA_DB_URL_MT,
  verbose = FALSE
)

tRNAdb2GFF(input)
}
\arguments{
\item{tdbID}{a tRNAdb ID}

\item{database}{"RNA" or "DNA"}

\item{origin}{one ore more of "plastid", "mitochondrial" or "allothers"}

\item{dbURL}{the URL of the tRNA db}

\item{verbose}{whether to report verbose information from the httr2 calls}

\item{mtdbID}{a mtRNAdb ID}

\item{blastSeq}{a sequence to use for a blast search}

\item{organism}{a organism name as a character string}

\item{strain}{a strain information as a character string}

\item{taxonomyID}{organism and strain information as a taxonom ID}

\item{aminoacids}{a character vector of amino acids as a three letter code}

\item{anticodons}{a character vector of anticodon sequences}

\item{sequences}{a named (1-15) list of sequences, which are used for the
search}

\item{structures}{a named (1-15) list of structures, which are used for the
search. Please use the \code{\(\)} or \code{><} dot bracket annotation.}

\item{reference}{a reference as a character string}

\item{comment}{a comment as a character string}

\item{pubmed}{a pubmed ID}

\item{genes}{a gene name as a character string}

\item{input}{a GRanges object which passes the \code{istRNAdbGRanges} check}
}
\value{
a GRanges object containing the information from the tRNA db
}
\description{
title
}
\examples{
import.tRNAdb(organism = "Saccharomyces cerevisiae",
              aminoacids = c("Phe","Ala"))
import.tRNAdb.id(tdbID = "tdbD00000785")
import.tRNAdb.blast(blastSeq =
"GCGGATTTAGCTCAGTTGGGAGAGCGCCAGACTGAAGATCTGGAGGTCCTGTGTTCGATCCACAGAATTCGCA")
import.mttRNAdb(organism = "Bos taurus",
                aminoacids = c("Phe","Ala"))
import.mttRNAdb.id(mtdbID = "mtdbD00000900")
}
\keyword{datasets}
