% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MDSplot.R
\name{MDSplot}
\alias{MDSplot}
\title{Multidimensional scaling with MDSplot}
\usage{
MDSplot(
  exploredds,
  method = "spearman",
  plotly = FALSE,
  savePlot = FALSE,
  filePlot = NULL
)
}
\arguments{
\item{exploredds}{object of class \code{\link[DESeq2:DESeqDataSet]{DESeq2::DESeqDataSet()}}, generated from
\code{exploreDDS} function.}

\item{method}{a \verb{character string} indicating which correlation coefficient
is to be computed, based on the \code{\link[stats:cor]{stats::cor()}} function. Options are:
c("pearson" "kendall", "spearman").}

\item{plotly}{logical: when \code{FALSE} (default), the \code{ggplot2} plot will be
returned. \code{TRUE} option returns the \code{plotly} version of the plot.}

\item{savePlot}{logical: when \code{FALSE} (default), the plot will not be saved.
If \code{TRUE} the plot will be saved, and requires the \code{filePlot} argument.}

\item{filePlot}{file name where the plot will be saved. For more information,
please consult the \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}} function.}
}
\value{
returns an object of \code{ggplot} or \code{plotly} class.
}
\description{
This function computes and plots multidimensional scaling
analysis for dimension reduction of count expression matrix. Internally, it
is applied the \code{\link[stats:dist]{stats::dist()}} function to the transformed count matrix to
get sample-to-sample distances.
}
\examples{
## Targets file
targetspath <- system.file("extdata", "targets.txt", package = "systemPipeR")
targets <- read.delim(targetspath, comment = "#")
cmp <- systemPipeR::readComp(file = targetspath, format = "matrix", 
delim = "-")
## Count table file
countMatrixPath <- system.file("extdata", "countDFeByg.xls", 
package = "systemPipeR")
countMatrix <- read.delim(countMatrixPath, row.names = 1)
## Plot
exploredds <- exploreDDS(countMatrix, targets, cmp = cmp[[1]], 
preFilter = NULL, transformationMethod = "rlog")
MDSplot(exploredds, plotly = FALSE)
}
\keyword{visualization}
