% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_two_drugs.R
\name{Plot2DrugHeatmap}
\alias{Plot2DrugHeatmap}
\title{Heatmap Plot for 2-drug Combination Dose-Response/Synergy Scores}
\usage{
Plot2DrugHeatmap(
  data,
  plot_block = 1,
  drugs = c(1, 2),
  plot_value = "response",
  statistic = NULL,
  summary_statistic = NULL,
  dynamic = FALSE,
  plot_title = NULL,
  col_range = NULL,
  row_range = NULL,
  color_range = NULL,
  high_value_color = "#FF0000",
  low_value_color = "#00FF00",
  text_label_size_scale = 1,
  text_label_color = "#000000",
  title_text_size_scale = 1
)
}
\arguments{
\item{data}{A list object generated by function \code{\link{ReshapeData}}.}

\item{plot_block}{A character/integer. It indicates the block ID for the
block to visualize.}

\item{drugs}{A vector of characters or integers with length of 2. It contains
the index for two drugs to plot. For example, \code{c(1, 2)} indicates to
plot "drug1" and "drug2" in the input \code{data}.}

\item{plot_value}{A character value. It indicates the value to be visualized.
If the \code{data} is the direct output from \link{ReshapeData}, the values
for this parameter are:
\itemize{
  \item \strong{response_origin} The original response value in input data.
  It might be \% inhibition or \% viability.
  \item \strong{response} The \% inhibition after preprocess by function 
  \link{ReshapeData}
}
If the \code{data} is the output from \link{CalculateSynergy}, following
values are also available:
\itemize{
  \item \strong{ZIP_ref, Bliss_ref, HSA_ref, Loewe_ref} The reference
  additive effects calculated by ZIP, Bliss, HSA or Loewe model,
  respectively.
  \item \strong{ZIP_synergy, Bliss_synergy, HSA_synergy, Loewe_synergy}
  The synergy score calculated by ZIP, Bliss, HSA or Loewe model,
  respectively.
  \item \strong{ZIP_fit} The response fitted by ZIP model.
}}

\item{statistic}{A character or NULL. It indicates the statistics printed
in the plot while there are replicates in input data. Available values are:
\itemize{
  \item \strong{sd} Standard deviation;
  \item \strong{sem} Standard error of mean;
  \item \strong{ci} 95\% confidence interval.
}
If it is \code{NULL}, no statistics will be printed.}

\item{summary_statistic}{A vector of characters or NULL. It indicates the
summary statistics for all the \code{plot_value} in whole combination
matrix. Available values are:
\itemize{
  \item \strong{mean} Median value for all the responses or synergy
  scores in the matrix and the p-value if it is valid;
  \item \strong{median} Median value for all the responses or synergy
  scores in the matrix;
  \item \strong{quantile_90} 90\% quantile. User could change the number to
  print different sample quantile. For example quantile_50 equal to median. 
}
If it is \code{NULL}, no statistics will be printed.}

\item{dynamic}{A logical value. If it is \code{TRUE}, this function will
use \link[plotly]{plot_ly} to generate an interactive plot. If it is
\code{FALSE}, this function will use \link[lattice]{wireframe} to generate
a static plot.}

\item{plot_title}{A character value. It specifies the plot title. If it is
\code{NULL}, the function will automatically generate a title.}

\item{col_range}{A vector of two integers. They specify the starting and 
ending concentration of the drug on x-axis. Use e.g., c(1, 3) to specify
that only from 1st to 3rd concentrations of the drug on x-axis are used. By
default, it is \code{NULL} so all the concentrations are used.}

\item{row_range}{A vector of two integers. They specify the starting and
ending concentration of the drug on y-axis. Use e.g., c(1, 3) to specify
that only from 1st to 3rd concentrations of the drug on y-axis are used. By
default, it is \code{NULL} so all the concentrations are used.}

\item{color_range}{A vector of two numeric values. They specify the range
of the color bars. The first item (lower bounder) must be less than the
second one (upper bounder). The plotted values larger than defined upper
bounder will be filled in color \code{high_value_color}. The plotted values
less than defined lower bounder will be filled in color
\code{low_value_color}. If the defined range includes 0, value 0 will be
filled in color "white". By default, it is set as \code{NULL} which
means the function will automatically set the color range according to
the plotted values.}

\item{high_value_color}{An R color value. It indicates the color for the
high values.}

\item{low_value_color}{An R color value. It indicates the color for low
values.}

\item{text_label_size_scale}{A numeric value. It is used to control the size
text labels on the heatmap. The text size will multiply by this scale
factor.}

\item{text_label_color}{NULL or an R color value. It indicates the color for
text labels on the heatmap. If it is \code{NULL}, no text will be shown.}

\item{title_text_size_scale}{A numeric value. It is used to control the size
of legend title, legend text, plot title, axis title, axis tick, subtitle.
All the text size will multiply by this scale factor.}
}
\value{
A ggplot plot object.
}
\description{
This function will generate a plot for 2-drug combinations. The axes are the
dosage at which drugs are tested. The values could be observed response,
synergy scores or the reference effects calculated from different models.
}
\examples{
data("mathews_screening_data")
data <- ReshapeData(mathews_screening_data)
Plot2DrugHeatmap(data)
}
\author{
\itemize{
  \item Shuyu Zheng \email{shuyu.zheng@helsinki.fi}
  \item Jing Tang \email{jing.tang@helsinki.fi}
}
}
