% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateSwfdr.R
\name{calculateSwfdr}
\alias{calculateSwfdr}
\title{Calculate the science-wise FDR (swfdr)}
\usage{
calculateSwfdr(
  pValues,
  truncated,
  rounded,
  pi0 = 0.5,
  alpha = 1,
  beta = 50,
  numEmIterations = 100
)
}
\arguments{
\item{pValues}{Numerical vector of p-values}

\item{truncated}{Vector of 0s and 1s with indices corresponding to those in
pValues; 1 indicates that the p-values is truncated, 0 that it is not truncated}

\item{rounded}{Vector of 0s and 1s with indices corresponding to those in pValues;
1 indicates that the p-values is rounded, 0 that it is not rounded}

\item{pi0}{Initial prior probability that a hypothesis is null (default is 0.5)}

\item{alpha}{Initial value of parameter alpha from Beta(alpha, beta) true positive
distribution (default is 1)}

\item{beta}{Initial value of parameter beta from Beta(alpha, beta) true positive
distribution (default is 50)}

\item{numEmIterations}{The number of EM iterations (default is 100)}
}
\value{
\item{pi0}{Final value of prior probability - estimated from EM -
that a hypothesis is null, i.e. estimated swfdr}
\item{alpha}{Final value of parameter alpha - estimated from EM -
from Beta(alpha, beta) true positive distribution}
\item{beta}{Final value of parameter beta - estimated from EM -
from Beta(alpha, beta) true positive distribution}
\item{z}{Vector of expected values of the indicator of whether the p-value is
null or not - estimated from EM - for the non-rounded p-values (values of NA
represent the rounded p-values)}
\item{n0}{Expected number of rounded null p-values - estimated from EM -
between certain cutpoints (0.005, 0.015, 0.025, 0.035, 0.045, 0.05)}
\item{n}{Number of rounded p-values between certain cutpoints
(0.005, 0.015, 0.025, 0.035, 0.045, 0.05)}
}
\description{
Calculate the science-wise FDR (swfdr)
}
\examples{
pVals <- runif(100)
tt <- rr <- rep(0, 100)
resSwfdr <- calculateSwfdr(pValues = pVals, truncated = tt, rounded = rr, numEmIterations=100)

}
