% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsd_filter.R
\name{rsd_filter}
\alias{rsd_filter}
\title{RSD filter}
\usage{
rsd_filter(rsd_threshold = 20, qc_label = "QC", factor_name, ...)
}
\arguments{
\item{rsd_threshold}{(numeric) The RSD threshold above which features are removed. The default is \code{20}.\cr}

\item{qc_label}{(character) The label used to identify QC samples. The default is \code{"QC"}.}

\item{factor_name}{(character) The name of a sample-meta column to use.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{rsd_filter} object with the following \code{output} slots:
\tabular{ll}{
\code{filtered} \tab          (DatasetExperiment) A DatasetExperiment object containing the filtered data. \cr
\code{flags} \tab          (data.frame) RSD and a flag indicating whether the feature was rejected by the filter or not. \cr
\code{rsd_qc} \tab          (data.frame) The calculated RSD of the QC class. \cr
}
}
\description{
An RSD filter calculates the relative standard deviation (the ratio of the standard deviation to the mean) for all features. Any feature with an RSD greater than a predefined threshold is excluded.
}
\details{
This object makes use of functionality from the following packages:\itemize{  \item{\code{pmp}}}
}
\section{Inheritance}{

A \code{rsd_filter} object inherits the following \code{struct} classes: \cr\cr
\verb{[rsd_filter]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = rsd_filter(
      rsd_threshold = 20,
      qc_label = "QC",
      factor_name = "V1")

M = rsd_filter(factor_name='Class')

}
\references{
Jankevics A, Lloyd GR, Weber RJM (????). \emph{pmp: Peak Matrix Processing
and signal batch correction for metabolomics datasets}. R package
version 1.15.1.
}
