% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_na_class.R
\name{prop_na}
\alias{prop_na}
\title{Fisher's exact test for missing values}
\usage{
prop_na(alpha = 0.05, mtc = "fdr", factor_name, ...)
}
\arguments{
\item{alpha}{(numeric) The p-value cutoff for determining significance. The default is \code{0.05}.\cr}

\item{mtc}{(character) Multiple test correction method. Allowed values are limited to the following: \itemize{ \item{\code{"bonferroni"}: Bonferroni correction in which the p-values are multiplied by the number of comparisons.}\item{\code{"fdr"}: Benjamini and Hochberg False Discovery Rate correction.}\item{\code{"none"}: No correction.}} The default is \code{"fdr"}.}

\item{factor_name}{(character) The name of a sample-meta column to use.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{prop_na} object with the following \code{output} slots:
\tabular{ll}{
\code{p_value} \tab          (data.frame) The probability of observing the calculated statistic. \cr
\code{significant} \tab          (data.frame) TRUE if the calculated p-value is less than the supplied threshold (alpha). \cr
\code{na_count} \tab          (data.frame) The number of NA values per group of the chosen factor. \cr
}

struct object
}
\description{
A Fisher's exact test is used to compare the number of missing values in each group. Multiple test corrected p-values are computed to indicate whether there is a significant difference in the number of missing values across groups for each feature.
}
\section{Inheritance}{

A \code{prop_na} object inherits the following \code{struct} classes: \cr\cr
\verb{[prop_na]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = prop_na(
      alpha = 0.05,
      mtc = "fdr",
      factor_name = "V1")

M = prop_na(factor_name='Species')

}
