% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn_impute_class.R
\name{knn_impute}
\alias{knn_impute}
\title{kNN missing value imputation}
\usage{
knn_impute(
  neighbours = 5,
  sample_max = 50,
  feature_max = 50,
  by = "features",
  ...
)
}
\arguments{
\item{neighbours}{(numeric) The number of neighbours (k) to use for imputation. The default is \code{5}.\cr}

\item{sample_max}{(numeric) The maximum percent missing values per sample. The default is \code{50}.\cr}

\item{feature_max}{(numeric) The maximum percent missing values per feature. The default is \code{50}.\cr}

\item{by}{(character) Impute using similar "samples" or "features". Default features. The default is \code{"features"}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{knn_impute} object with the following \code{output} slots:
\tabular{ll}{
\code{imputed} \tab          (DatasetExperiment) A DatasetExperiment object containing the data where missing values have been imputed. \cr
}
}
\description{
k-nearest neighbour missing value imputation replaces missing values in the data with the average of a predefined number of the most similar neighbours for which the value is present
}
\details{
This object makes use of functionality from the following packages:\itemize{  \item{\code{pmp}}}
}
\section{Inheritance}{

A \code{knn_impute} object inherits the following \code{struct} classes: \cr\cr
\verb{[knn_impute]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = knn_impute(
      neighbours = 5,
      feature_max = 50,
      sample_max = 50,
      by = "features")

M = knn_impute()
}
\references{
Jankevics A, Lloyd GR, Weber RJM (????). \emph{pmp: Peak Matrix Processing
and signal batch correction for metabolomics datasets}. R package
version 1.15.1.
}
