% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_plot_array_class.R
\name{feature_profile_array}
\alias{feature_profile_array}
\title{Feature profile}
\usage{
feature_profile_array(
  run_order,
  qc_label,
  qc_column,
  colour_by,
  feature_to_plot,
  nrow = 5,
  log = TRUE,
  ...
)
}
\arguments{
\item{run_order}{(character) The sample-meta column name containing run order.}

\item{qc_label}{(character) The label used to identify QC samples.}

\item{qc_column}{(character) The sample-meta column name containing the labels used to identify QC samples.}

\item{colour_by}{(character) The sample-meta column name to used to colour the plot.}

\item{feature_to_plot}{(numeric, character, integer) The name or column id of the plotted feature.}

\item{nrow}{(numeric, integer) The number of rows in the plot. The default is \code{5}.\cr}

\item{log}{(logical) Log transform. Allowed values are limited to the following: \itemize{ \item{\code{"TRUE"}: The data is log tranformed before plotting.}\item{\code{"FALSE"}: The data is not transformed before plotting.}} The default is \code{TRUE}.\cr}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{
feature_profile_array
} object. This object has no \code{output} slots.
See \code{\link[struct]{chart_plot}} in the \code{struct} package to plot this chart object.
}
\description{
A plot visualising the change in intensity of a feature with a continuous variable such as time, dose, or run order.
}
\section{Inheritance}{

A \code{feature_profile_array} object inherits the following \code{struct} classes: \cr\cr
\verb{[feature_profile_array]} >> \verb{[chart]} >> \verb{[struct_class]}
}

\examples{
M = feature_profile_array(
      run_order = character(0),
      qc_label = character(0),
      qc_column = character(0),
      colour_by = character(0),
      feature_to_plot = numeric(0),
      nrow = 1,
      log = FALSE)

D = MTBLS79_DatasetExperiment()
C = feature_profile_array(
    run_order='run_order',
    qc_label='QC',
    qc_column='Class',
    colour_by='Class',
    feature_to_plot=1:3,
    nrow=1,
    log=TRUE)
chart_plot(C,D)
}
