% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confounders_clsq_class.R
\name{confounders_lsq_boxplot}
\alias{confounders_lsq_boxplot}
\title{Confounding factor relative change boxplot}
\usage{
confounders_lsq_boxplot(threshold = 10, ...)
}
\arguments{
\item{threshold}{(numeric) A horizontal line is plotted to indicate the threshold. The default is \code{10}.\cr}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{
confounders_lsq_boxplot
} object. This object has no \code{output} slots.
See \code{\link[struct]{chart_plot}} in the \code{struct} package to plot this chart object.
}
\description{
A boxplot of the relative change (delta) in regression coefficient when potential confounding factors are included, and excluded, from the model. Factors with a large delta are considered to be confounding factors.
}
\section{Inheritance}{

A \code{confounders_lsq_boxplot} object inherits the following \code{struct} classes: \cr\cr
\verb{[confounders_lsq_boxplot]} >> \verb{[chart]} >> \verb{[struct_class]}
}

\examples{
M = confounders_lsq_boxplot(
      threshold = 10)

D = MTBLS79_DatasetExperiment()
M = filter_by_name(mode='include',dimension='variable',
        names=colnames(D$data)[1:10]) + # first 10 features
    filter_smeta(mode='exclude',levels='QC',
        factor_name='Class') + # reduce to two group comparison
    confounders_clsq(factor_name = 'Class',
        confounding_factors=c('run_order','Batch'))
M = model_apply(M,D)
C = C=confounders_lsq_boxplot(threshold=15)
chart_plot(C,M[3])
}
