% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_chart_classes.R
\name{DatasetExperiment_heatmap}
\alias{DatasetExperiment_heatmap}
\title{DatasetExperiment heatmap}
\usage{
DatasetExperiment_heatmap(na_colour = "#FF00E4", ...)
}
\arguments{
\item{na_colour}{(character) The hex colour code used to plot missing values. The default is \code{"#FF00E4"}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{
DatasetExperiment_heatmap
} object. This object has no \code{output} slots.
See \code{\link[struct]{chart_plot}} in the \code{struct} package to plot this chart object.
}
\description{
A heatmap to visualise the measured values in a data matrix.
}
\details{
This object makes use of functionality from the following packages:\itemize{  \item{\code{reshape2}}}
}
\section{Inheritance}{

A \code{DatasetExperiment_heatmap} object inherits the following \code{struct} classes: \cr\cr
\verb{[DatasetExperiment_heatmap]} >> \verb{[chart]} >> \verb{[struct_class]}
}

\examples{
M = DatasetExperiment_heatmap(
      na_colour = "#FF00E4")

D = iris_DatasetExperiment()
C = DatasetExperiment_heatmap()
chart_plot(C,D)
}
\references{
Wickham H (2007). "Reshaping Data with the reshape Package." \emph{Journal
of Statistical Software}, \emph{21}(12), 1-20.
\url{http://www.jstatsoft.org/v21/i12/}.
}
