% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUC_metric_class.R
\name{AUC}
\alias{AUC}
\title{Area under ROC curve}
\usage{
AUC(...)
}
\arguments{
\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{
AUC
} object. This object has no \code{output} slots.
}
\description{
The area under the ROC curve of a classifier is estimated using the trapezoid method.
}
\section{Inheritance}{

A \code{AUC} object inherits the following \code{struct} classes: \cr\cr
\verb{[AUC]} >> \verb{[metric]} >> \verb{[struct_class]}
}

\examples{
M = AUC()

D = iris_DatasetExperiment()
XCV = kfold_xval(folds=5,factor_name='Species') *
      (mean_centre() + PLSDA(number_components=2,factor_name='Species'))
MET = AUC()
XCV = run(XCV,D,MET)
}
