% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcaOtherPlotting.R
\name{plotScreePCA}
\alias{plotScreePCA}
\title{Plot the PCA scree plot.}
\usage{
plotScreePCA(
  spe_object,
  dims = ncol(spe_object),
  precomputed = NULL,
  assay = 1,
  bar_color = "black",
  bar_fill = "royalblue",
  bar_width = 0.8,
  point_col = "tomato3",
  line_col = "tomato3",
  point_size = 2
)
}
\arguments{
\item{spe_object}{A SpatialExperiment object.}

\item{dims}{The top n dimensions to be plotted}

\item{precomputed}{a dimensional reduction results from \code{stats::prcomp}.
result in \code{reducedDims(object)} to plot. Default is NULL,
we will compute for you.}

\item{assay}{a numeric or character, specifying the assay to use (for
\code{SummarizedExperiment} and its derivative classes).}

\item{bar_color}{Color for bar.}

\item{bar_fill}{Fill for bar.}

\item{bar_width}{Bar width.}

\item{point_col}{Color for point.}

\item{line_col}{Color for line.}

\item{point_size}{Point size.}
}
\value{
A ggplot object.
}
\description{
Plot the PCA scree plot.
}
\examples{
data("dkd_spe_subset")
plotScreePCA(dkd_spe_subset, dims = 10)
}
