% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterization.R
\name{rasterizeEachCluster}
\alias{rasterizeEachCluster}
\title{Create a raster object from a labeled sample}
\usage{
rasterizeEachCluster(sampleInfo)
}
\arguments{
\item{sampleInfo}{A data.frame contains the pixel information and cluster labels for each barcode of a human breast cancer sample.
The index contains barcodes, and at least three other columns that have these information are required and the column names should be the same as following:
"imagerow": The row pixel coordinate of the center of the spot
"imagecol": The column pixel coordinate of the center of the spot
"Cluster": The label that corresponding to this barcode}
}
\value{
This function returns a class of RasterLayer. This raster object is converted from a labeled spatial tissue map.
}
\description{
Converts a labeled spatial tissue map into a raster object,
in which each spatial cluster is represented by a pixel coded by label assignment.
}
\examples{
fpath <- system.file("extdata", "dataframe.rda", package="stJoincount")
load(fpath)
mosaicIntegration <- rasterizeEachCluster(humanBC)
}
