% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRegions.R
\name{plotRegions}
\alias{plotRegions}
\title{Plot the coverage information surrounding genomic regions}
\usage{
plotRegions(
  object,
  region,
  normCvg = TRUE,
  annot = NULL,
  allSignReg = TRUE,
  featureAnnot = NULL,
  flankReg = 10,
  colGroup = c("#0080ff", "#ff00ff"),
  fillReg = c("darkgreen", "darkred"),
  fillAnnot = "#FFD58A",
  type = "a",
  chrTitle = TRUE,
  trNames = c("DER", "coverage"),
  legend = TRUE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{\link{srnadiffExp}} as returned
by \code{\link{srnadiff}} function.}

\item{region}{A \code{GRanges} object. By example, ranges in the
output from \code{\link{regions}} used on an object of
class \code{\link{srnadiffExp}}.}

\item{normCvg}{Boolean. If \code{TRUE} (the default), normalized
coverages are displayed, else, the raw coverages are
used.}

\item{annot}{A \code{GRanges} or \code{data.frame} object containing
gene and/or sRNA annotation information.}

\item{allSignReg}{Boolean. If \code{TRUE}, all differeltially expressed
regions contained in the annotated regions will be
displayed.}

\item{featureAnnot}{Character scalar. Feature annotation to be used, it
will be one from column names of \code{mcols(annot)}
if \code{annot} is a \code{GRanges} or one from
\code{colnames(annot)} if \code{annot} is a
\code{data.frame}.}

\item{flankReg}{Integer value. If \code{flankReg} is positive, the
displayed genomic interval is extended by
\code{flankReg} nucleotides from the minimum
\code{start} and maximum \code{end} from the displayed
(ranges) regions.}

\item{colGroup}{Character vector of length 2. The fill colors to be used
to indicate samples per group.}

\item{fillReg}{Character vector of length 2. The fill colors to be used
to indicate 'up' or 'down' regulated regions.}

\item{fillAnnot}{Character scalar. The fill color to be used for
annotated regions.}

\item{type}{Character vector. The plot type, one of
(\code{"a", "l", "p", "b", "confint"}) or combinations
thereof. See Details for more information on the
individual plotting types.}

\item{chrTitle}{Boolean or character vector of length one. Defaults
\code{TRUE}, the chromosome name is added to the plot.
If character, this will be used for title.}

\item{trNames}{Title for the tracks. By default \code{"DER"} and
\code{"coverage"}.}

\item{legend}{Boolean triggering the addition of a legend to the
(coverage) data track to indicate groups.}

\item{...}{Additional display parameters to control the look and
feel of the plots. See the "Display Parameters" section
for functions \code{\link{GenomeAxisTrack}},
\code{\link{GeneRegionTrack}},
\code{\link{AnnotationTrack}}, \code{\link{DataTrack}}
in the \code{Gviz} package.}
}
\value{
A list of GenomeGraph track objects, all inheriting
                    from class \code{GdObject}.
}
\description{
This function plot the coverage information surrounding genomic regions
while summarizing the annotation.
}
\details{
This function provides a flexible genomic visualization framework by
displaying tracks in the sense of the \code{Gviz} package. Given
a region (or regions), four separate tracks are represented:
(1) \code{\link[Gviz]{GenomeAxisTrack}}, a horizontal axis with genomic
coordinate tickmarks for reference location to the displayed genomic
regions;
(2) \code{\link[Gviz]{GeneRegionTrack}}, if the \code{annot} argument is
passed, a track displaying all gene and/or sRNA annotation information
in a particular region;
(3) \code{\link[Gviz]{AnnotationTrack}}, regions are plotted as simple
boxes if no strand information is available, or as arrows to indicate
their direction; and
(4) \code{\link[Gviz]{DataTrack}}, plot the sample coverages surrounding
the genomic regions.

The sample coverages can be plotted in various different forms as well
as combinations thereof. Supported plotting types are:

\describe{
\item{\code{p:}}{ simple dot plot.}
\item{\code{l:}}{ lines plot.}
\item{\code{b:}}{ combination of dot and lines plot.}
\item{\code{a:}}{ lines plot of the sample-groups average (i.e., mean)
        values.}
\item{\code{confint:}}{ confidence intervals for average values. In
        combination with \code{a} type.}
}
}
\examples{
srnaExp <- srnadiffExample()
srnaExp <- srnadiff(srnaExp)

plotRegions(srnaExp, regions(srnaExp)[1])
plotRegions(srnaExp, regions(srnaExp)[1], type = c("a", "confint"))

}
