% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logModelFunctions.R
\name{logModelFeatQuality}
\alias{logModelFeatQuality}
\title{Turn 0-1 likelihood values into categorical (good/bad) classifications}
\usage{
logModelFeatQuality(
  feature_metrics,
  feature_labels,
  log_formula = feat_class ~ med_cor + med_snr,
  likelihood_threshold = 0.5,
  verbosity = 2
)
}
\arguments{
\item{feature_metrics}{A data.frame with columns used to construct the
feature quality model.}

\item{feature_labels}{A character vector named with feature IDs and entries
corresponding to the peak quality (either "Good", "Bad", or NA).}

\item{log_formula}{The formula to use when predicting feature quality from
the feature metrics. This formula is passed to `glm` as-is, so make sure that
the predictive features exist in the feature_metrics data.frame.}

\item{likelihood_threshold}{A scalar numeric above which features will be
kept if their predicted probability exceeds.}

\item{verbosity}{Scalar value between zero and two determining how much
diagnostic information is produced. 0 should return nothing, 1 should
return text-based progress markers, and 2 will return diagnostic plots if
available.}
}
\value{
A character vector of feature quality assessments returned by the
logistic model and named by feature ID
}
\description{
This function wraps `logModelFeatProb` for modeling of feature quality
to estimate the quality of every feature in the dataset and classify
them as good/bad based on whether they exceed the provided
`likelihood_threshold`. Lower likelihood thresholds (0.01, 0.1) will produce
more false positives (noise peaks included when they shouldn't be). Higher
likelihood thresholds (0.9, 0.99) will produce more false negatives (good
peaks removed when they shouldn't be).
}
\examples{
library(xcms)
library(dplyr)
library(MSnbase)
mzML_files <- system.file("extdata", package = "RaMS") \%>\%
    list.files(full.names = TRUE, pattern = "[A-F].mzML")
register(BPPARAM = SerialParam())
cwp <- CentWaveParam(snthresh = 0, extendLengthMSW = TRUE, integrate = 2)
obp <- ObiwarpParam(binSize = 0.1, response = 1, distFun = "cor_opt")
pdp <- PeakDensityParam(
    sampleGroups = 1:3, bw = 12, minFraction = 0,
    binSize = 0.001, minSamples = 0
)
xcms_filled <- mzML_files \%>\%
    readMSData(msLevel. = 1, mode = "onDisk") \%>\%
    findChromPeaks(cwp) \%>\%
    adjustRtime(obp) \%>\%
    groupChromPeaks(pdp) \%>\%
    fillChromPeaks(FillChromPeaksParam(ppm = 5))
peak_data <- makeXcmsObjFlat(xcms_filled)
feat_metrics <- extractChromMetrics(peak_data, verbosity = 0)

# Load demo labels previously assigned using the lasso method
lasso_classes <- readRDS(system.file("extdata", "intro_lasso_labels.rds", package = "squallms"))
feat_classes <- logModelFeatQuality(feat_metrics, lasso_classes)
}
