% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelFeatsFunctions.R
\name{labelFeatsManual}
\alias{labelFeatsManual}
\title{Label chromatographic features manually one at a time via interactive interface}
\usage{
labelFeatsManual(peak_data, ms1_data = NULL, verbosity = 1)
}
\arguments{
\item{peak_data}{Flat-form XC-MS data with columns for the bounding box of
a chromatographic peak (mzmin, mzmax, rtmin, rtmax) as grouped by a feature
ID. Must be provided WITHOUT retention time correction for proper matching
to the values in the raw data.}

\item{ms1_data}{Optional data.table object produced by RaMS containing MS1
data with columns for filename, rt, mz, and int. If not provided, the files
are detected from the filepath column in peak_data.}

\item{verbosity}{Scalar value between zero and two determining how much
diagnostic information is produced. 0 should return nothing while 1 will
report diagnostic messages.}
}
\value{
A character vector named with feature IDs containing the classifications
of each peak that was viewed during the interactive phase. NA values indicate
those features that were not classified.
}
\description{
This function allows the user to view and label individual chromatographic
features using the keyboard. Running labelFeatsManual launches a browser
which shows a single feature extracted from multiple files. The feature can
then be classified by pressing a key (defaults are left=bad, right=good) on 
the keyboard which is recorded and a new feature is automatically shown.This 
implementation relies on R's \pkg{shiny} package
to provide interactive support in a browser environment and the
\pkg{keys} package for key binding within a browser. Classified features are then
returned as a simple R object for downstream use.
}
\examples{
library(xcms)
library(dplyr)
library(MSnbase)
mzML_files <- system.file("extdata", package = "RaMS") \%>\%
    list.files(full.names = TRUE, pattern = "[A-F].mzML")
register(BPPARAM = SerialParam())
cwp <- CentWaveParam(snthresh = 0, extendLengthMSW = TRUE, integrate = 2)
obp <- ObiwarpParam(binSize = 0.1, response = 1, distFun = "cor_opt")
pdp <- PeakDensityParam(
    sampleGroups = 1:3, bw = 12, minFraction = 0,
    binSize = 0.001, minSamples = 0
)
xcms_filled <- mzML_files \%>\%
    readMSData(msLevel. = 1, mode = "onDisk") \%>\%
    findChromPeaks(cwp) \%>\%
    adjustRtime(obp) \%>\%
    groupChromPeaks(pdp) \%>\%
    fillChromPeaks(FillChromPeaksParam(ppm = 5))
peak_data <- makeXcmsObjFlat(xcms_filled)
if (interactive()) {
    manual_labels <- labelFeatsManual(peak_data)
}
}
