% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock-data.R
\name{mockEmpiricalSet}
\alias{mockEmpiricalSet}
\title{Generate set of "empirical" mock data}
\usage{
mockEmpiricalSet(
  n.genes = 20,
  n.snps = 1000,
  n.samples = 10,
  chromosome = 1,
  chr.length = 2e+06,
  seed = NULL
)
}
\arguments{
\item{n.genes}{Number of genes in mock eQTL data.}

\item{n.snps}{Number of SNPs in mock vcf file.}

\item{n.samples}{Number of samples in mock bulk data.}

\item{chromosome}{Chromosome name}

\item{chr.length}{Length of mock chromosome}

\item{seed}{Optional: seed for random seed}
}
\value{
list(gff=mockGFF, vcf=mockVCF, means=mockMEANS, eqtl=mockEQTL)
}
\description{
Quick function to generate matching mock VCF, bulk expression, and eQTL data,
useful for running splatPopEmpiricalMeans
}
\examples{
empirical <- mockEmpiricalSet()

}
